(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6790,        230]
NotebookOptionsPosition[      5030,        175]
NotebookOutlinePosition[      6146,        205]
CellTagsIndexPosition[      6103,        202]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MolarGasConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MolarGasConstant"], 
          "AvogadroConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AvogadroConstant"], 
          "BoltzmannConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/BoltzmannConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MolarGasConstant\"\>", 
       2->"\<\"AvogadroConstant\"\>", 
       3->"\<\"BoltzmannConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SackurTetrodeConstant", "ObjectName",
 CellID->22033],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SackurTetrodeConstant"], "InlineFormula"],
     " \[LineSeparator]is the absolute entropy constant, a \
physico\[Dash]chemical constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SackurTetrodeConstant"], "InlineFormula"],
 " is a unitless number."
}], "Notes",
 CellID->28141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29204],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MolarGasConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MolarGasConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvogadroConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoltzmannConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/BoltzmannConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6777]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17709],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->28595]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SackurTetrodeConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 31.3295690}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "SackurTetrodeConstant is the absolute entropy constant, a \
physico\\[Dash]chemical constant.", "synonyms" -> {}, "title" -> 
    "SackurTetrodeConstant", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/SackurTetrodeConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1600, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2223, 68, 59, 1, 70, "ObjectName",
 CellID->22033],
Cell[2285, 71, 381, 11, 70, "Usage",
 CellID->21694]
}, Open  ]],
Cell[CellGroupData[{
Cell[2703, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3181, 104, 128, 4, 70, "Notes",
 CellID->28141]
}, Closed]],
Cell[CellGroupData[{
Cell[3346, 113, 311, 9, 70, "SeeAlsoSection",
 CellID->29204],
Cell[3660, 124, 799, 26, 70, "SeeAlso",
 CellID->6777]
}, Open  ]],
Cell[CellGroupData[{
Cell[4496, 155, 314, 9, 70, "TutorialsSection",
 CellID->17709],
Cell[4813, 166, 175, 4, 70, "Tutorials",
 CellID->28595]
}, Open  ]],
Cell[5003, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

