(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6824,        231]
NotebookOptionsPosition[      4949,        175]
NotebookOutlinePosition[      6174,        206]
CellTagsIndexPosition[      6131,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SolarRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarRadius"], "SolarLuminosity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarLuminosity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SolarRadius\"\>", 
       2->"\<\"SolarLuminosity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SolarConstant", "ObjectName",
 CellID->17184],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SolarConstant"], "InlineFormula"],
     " \[LineSeparator]is the rate at which solar radiation is received \
outside the Earth\[CloseCurlyQuote]s atmosphere on a surface normal to the \
incident radiation and at the Earth\[CloseCurlyQuote]s mean distance from the \
Sun."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SolarConstant"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Watt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Watt"], "/", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["Meter",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Meter"], "^", "2"}], ")"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->8752]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25569],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarLuminosity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarLuminosity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1288623173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14524],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->10018]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SolarConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 31.5170738}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "SolarConstant is the rate at which solar radiation is received outside \
the Earth\\[CloseCurlyQuote]s atmosphere on a surface normal to the incident \
radiation and at the Earth\\[CloseCurlyQuote]s mean distance from the Sun.", 
    "synonyms" -> {}, "title" -> "SolarConstant", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/SolarConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1398, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2021, 63, 51, 1, 70, "ObjectName",
 CellID->17184],
Cell[2075, 66, 515, 13, 70, "Usage",
 CellID->23415]
}, Open  ]],
Cell[CellGroupData[{
Cell[2627, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3105, 101, 410, 16, 70, "Notes",
 CellID->8752]
}, Closed]],
Cell[CellGroupData[{
Cell[3552, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->25569],
Cell[3866, 133, 512, 17, 70, "SeeAlso",
 CellID->1288623173]
}, Open  ]],
Cell[CellGroupData[{
Cell[4415, 155, 314, 9, 70, "TutorialsSection",
 CellID->14524],
Cell[4732, 166, 175, 4, 70, "Tutorials",
 CellID->10018]
}, Open  ]],
Cell[4922, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

