(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6544,        222]
NotebookOptionsPosition[      4681,        166]
NotebookOutlinePosition[      5903,        197]
CellTagsIndexPosition[      5860,        194]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoltzmannConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/BoltzmannConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"BoltzmannConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StefanConstant", "ObjectName",
 CellID->23916],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["StefanConstant"], "InlineFormula"],
     " \[LineSeparator]is the Stefan\[Dash]Boltzmann constant, a universal \
constant of proportionality between the radiant emittance of a black body and \
the fourth power of the body\[CloseCurlyQuote]s absolute temperature."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["StefanConstant"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Watt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Watt"], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Kelvin",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Kelvin"], "^", "4"}], "*", 
     RowBox[{
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"], "^", "2"}]}], ")"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->27198]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9164],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BoltzmannConstant",
   BaseStyle->"Link",
   ButtonData->"paclet:PhysicalConstants/ref/BoltzmannConstant"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6762],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->20157]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StefanConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 39.0016404}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "StefanConstant is the Stefan\\[Dash]Boltzmann constant, a universal \
constant of proportionality between the radiant emittance of a black body and \
the fourth power of the body\\[CloseCurlyQuote]s absolute temperature.", 
    "synonyms" -> {}, "title" -> "StefanConstant", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/StefanConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1268, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1891, 61, 52, 1, 70, "ObjectName",
 CellID->23916],
Cell[1946, 64, 507, 12, 70, "Usage",
 CellID->13855]
}, Open  ]],
Cell[CellGroupData[{
Cell[2490, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2968, 98, 562, 21, 70, "Notes",
 CellID->27198]
}, Closed]],
Cell[CellGroupData[{
Cell[3567, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->9164],
Cell[3880, 135, 231, 6, 70, "SeeAlso",
 CellID->6704]
}, Open  ]],
Cell[CellGroupData[{
Cell[4148, 146, 313, 9, 70, "TutorialsSection",
 CellID->6762],
Cell[4464, 157, 175, 4, 70, "Tutorials",
 CellID->20157]
}, Open  ]],
Cell[4654, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

