(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6947,        234]
NotebookOptionsPosition[      5218,        180]
NotebookOutlinePosition[      6304,        209]
CellTagsIndexPosition[      6261,        206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClassicalElectronRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ClassicalElectronRadius"], 
          "SpeedOfLight" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SpeedOfLight"], 
          "CosmicBackgroundTemperature" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/CosmicBackgroundTemperature"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ClassicalElectronRadius\"\>",
        2->"\<\"SpeedOfLight\"\>", 
       3->"\<\"CosmicBackgroundTemperature\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ThomsonCrossSection", "ObjectName",
 CellID->9747],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ThomsonCrossSection"], "InlineFormula"],
     " \[LineSeparator]is the Thomson cross section, an atomic constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31295]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ThomsonCrossSection"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"], "^", "2"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14400]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22050],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassicalElectronRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ClassicalElectronRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpeedOfLight",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CosmicBackgroundTemperature",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/CosmicBackgroundTemperature"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->861],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->13463]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ThomsonCrossSection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 39.1578944}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ThomsonCrossSection is the Thomson cross section, an atomic constant.", 
    "synonyms" -> {}, "title" -> "ThomsonCrossSection", "type" -> "Symbol", 
    "uri" -> "PhysicalConstants/ref/ThomsonCrossSection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1640, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2263, 68, 56, 1, 70, "ObjectName",
 CellID->9747],
Cell[2322, 71, 358, 10, 70, "Usage",
 CellID->31295]
}, Open  ]],
Cell[CellGroupData[{
Cell[2717, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3195, 103, 277, 10, 70, "Notes",
 CellID->14400]
}, Closed]],
Cell[CellGroupData[{
Cell[3509, 118, 311, 9, 70, "SeeAlsoSection",
 CellID->22050],
Cell[3823, 129, 826, 26, 70, "SeeAlso",
 CellID->18968]
}, Open  ]],
Cell[CellGroupData[{
Cell[4686, 160, 312, 9, 70, "TutorialsSection",
 CellID->861],
Cell[5001, 171, 175, 4, 70, "Tutorials",
 CellID->13463]
}, Open  ]],
Cell[5191, 178, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

