(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6339,        219]
NotebookOptionsPosition[      4610,        165]
NotebookOutlinePosition[      5695,        194]
CellTagsIndexPosition[      5652,        191]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VacuumPermeability" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/VacuumPermeability"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"VacuumPermeability\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VacuumPermittivity", "ObjectName",
 CellID->15450],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["VacuumPermittivity"], "InlineFormula"],
     " \[LineSeparator]is the permittivity of vacuum, a universal constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["VacuumPermittivity"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"], "*", 
   RowBox[{
    ButtonBox["Second",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Second"], "/", 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"], "*", 
      ButtonBox["Volt",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Volt"]}], ")"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16736]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16921],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["VacuumPermeability",
   BaseStyle->"Link",
   ButtonData->"paclet:PhysicalConstants/ref/VacuumPermeability"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->16628]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25067],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->30054]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VacuumPermittivity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 39.5016532}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "VacuumPermittivity is the permittivity of vacuum, a universal constant.",
     "synonyms" -> {}, "title" -> "VacuumPermittivity", "type" -> "Symbol", 
    "uri" -> "PhysicalConstants/ref/VacuumPermittivity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1271, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1894, 61, 56, 1, 70, "ObjectName",
 CellID->15450],
Cell[1953, 64, 360, 10, 70, "Usage",
 CellID->22704]
}, Open  ]],
Cell[CellGroupData[{
Cell[2350, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2828, 96, 626, 22, 70, "Notes",
 CellID->16736]
}, Closed]],
Cell[CellGroupData[{
Cell[3491, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->16921],
Cell[3805, 134, 234, 6, 70, "SeeAlso",
 CellID->16628]
}, Open  ]],
Cell[CellGroupData[{
Cell[4076, 145, 314, 9, 70, "TutorialsSection",
 CellID->25067],
Cell[4393, 156, 175, 4, 70, "Tutorials",
 CellID->30054]
}, Open  ]],
Cell[4583, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

