(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19342,        657]
NotebookOptionsPosition[     16241,        552]
NotebookOutlinePosition[     17510,        589]
CellTagsIndexPosition[     17425,        584]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PIE CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PieChart" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieChart"], "Disk" :> 
         Documentation`HelpLookup["paclet:ref/Disk"], "PieStyle" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieStyle"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"PieChart\"\>", 2->"\<\"Disk\"\>", 
      3->"\<\"PieStyle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PieExploded", "ObjectName",
 CellID->6166],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PieExploded"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PieChart",
       BaseStyle->"Link",
       ButtonData->"paclet:PieCharts/ref/PieChart"]], "InlineFormula"],
     " that specifies the distance to move wedges outwards radially in the \
pie chart."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->319],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["wedge", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["wedge", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "list of wedges to move outwards radially", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["wedge", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["dist", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["wedge", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["dist", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "pairs of wedge number and relative distance", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "don't move any wedges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "separate all the wedges", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->13828],

Cell[TextData[{
 "Distances ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dist", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are expressed as a ratio of the distance to the radius of the pie; i.e., \
",
 Cell[BoxData["0.1"], "InlineFormula"],
 " moves a wedge outward 1/10th the radius of the pie."
}], "Notes",
 CellID->951],

Cell[TextData[{
 "Wedges are numbered counterclockwise from ",
 Cell[BoxData[
  StyleBox["theta", "TI"]], "InlineFormula"],
 " = ",
 Cell[BoxData["0"], "InlineFormula"],
 " (a line extending to the right from the center of the pie.)"
}], "Notes",
 CellID->28875]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4039804],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->224532984],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->212313888],

Cell["Leave all the wedges together:", "ExampleText",
 CellID->1045780101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"PieExploded", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1658030956],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.180783208205241}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.180783208205241, 8.078381109230897}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {8.078381109230897, 9.873576911282207}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.873576911282207, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5405813207414515, 0.26033024347053474`}], 
    InsetBox["2", {0.1335125603737888, 0.5849567473090941}], 
    InsetBox["3", {-0.5405813207414514, 0.26033024347053507`}], 
    InsetBox["4", {0.1335125603737884, -0.5849567473090942}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17174428]
}, Open  ]],

Cell["Explode the first and third wedges:", "ExampleText",
 CellID->1419990459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"PieExploded", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1541289730],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0.09009688679024193, 0.04338837391175579}, 1, {
      6.283185307179586, 7.180783208205241}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.180783208205241, 8.078381109230897}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{-0.0900968867902419, 0.043388373911755845`}, 1, {
      8.078381109230897, 9.873576911282207}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.873576911282207, 12.566370614359172`}]}}, {
    InsetBox["1", {0.6306782075316935, 0.3037186173822905}], 
    InsetBox["2", {0.1335125603737888, 0.5849567473090941}], 
    InsetBox["3", {-0.6306782075316932, 0.3037186173822909}], 
    InsetBox["4", {0.1335125603737884, -0.5849567473090942}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 334},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->552612020]
}, Open  ]],

Cell["Move the first and second wedges by specific amounts:", "ExampleText",
 CellID->793875302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "4"}], "}"}], ",", " ", 
   RowBox[{"PieExploded", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2091818866],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0.09238795325112868, 0.038268343236508996`}, 1, {
      6.283185307179586, 7.0685834705770345`}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0.07653668647301809, 0.1847759065022573}, 1, {
      7.0685834705770345`, 7.853981633974483}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.853981633974483, 9.42477796076938}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.42477796076938, 12.566370614359172`}]}}, {
    InsetBox["1", {0.6467156727579007, 0.26787840265556295`}], 
    InsetBox["2", {0.30614674589207236`, 0.7391036260090292}], 
    InsetBox["3", {-0.424264068711928, 0.424264068711929}], 
    InsetBox["4", {-2.5717582782094415`*^-16, -0.6}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 375},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->8806918]
}, Open  ]],

Cell["Separate all the wedges:", "ExampleText",
 CellID->346301903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"Range", "[", "4", "]"}], ",", " ", 
   RowBox[{"PieExploded", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1703694510],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0.09510565162951537, 0.03090169943749472}, 1, {
      6.283185307179586, 6.911503837897546}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0.030901699437494774`, 0.09510565162951536}, 1, {
      6.911503837897546, 8.168140899333462}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{-0.09510565162951534, 0.03090169943749478}, 1, {
      8.168140899333462, 10.053096491487338`}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0.0309016994374947, -0.09510565162951538}, 1, {
      10.053096491487338`, 12.566370614359172`}]}}, {
    InsetBox["1", {0.6657395614066075, 0.216311896062463}], 
    InsetBox["2", {0.2163118960624634, 0.6657395614066074}], 
    InsetBox["3", {-0.6657395614066074, 0.21631189606246343`}], 
    InsetBox["4", {0.2163118960624629, -0.6657395614066076}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->14604134]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12112],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieChart",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17910]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PieExploded - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 47.1112230}", "context" -> "PieCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Pie Charts Package Symbol",
     "language" -> "en", "paclet" -> "PieCharts Package", "status" -> "None", 
    "summary" -> 
    "PieExploded is an option for PieChart that specifies the distance to \
move wedges outwards radially in the pie chart.", "synonyms" -> {}, "title" -> 
    "PieExploded", "type" -> "Symbol", "uri" -> 
    "PieCharts/ref/PieExploded"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4848, 165, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4039804]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17284, 577}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 763, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1386, 44, 48, 1, 70, "ObjectName",
 CellID->6166],
Cell[1437, 47, 552, 16, 70, "Usage",
 CellID->1468]
}, Open  ]],
Cell[CellGroupData[{
Cell[2026, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2504, 85, 66, 1, 70, "Notes",
 CellID->319],
Cell[2573, 88, 1633, 49, 70, "2ColumnTableMod",
 CellID->13828],
Cell[4209, 139, 337, 11, 70, "Notes",
 CellID->951],
Cell[4549, 152, 262, 8, 70, "Notes",
 CellID->28875]
}, Closed]],
Cell[CellGroupData[{
Cell[4848, 165, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4039804],
Cell[CellGroupData[{
Cell[5231, 179, 148, 5, 70, "ExampleSection",
 CellID->224532984],
Cell[5382, 186, 132, 3, 70, "Input",
 CellID->212313888],
Cell[5517, 191, 74, 1, 70, "ExampleText",
 CellID->1045780101],
Cell[CellGroupData[{
Cell[5616, 196, 245, 7, 28, "Input",
 CellID->1658030956],
Cell[5864, 205, 1876, 57, 380, "Output",
 CellID->17174428]
}, Open  ]],
Cell[7755, 265, 79, 1, 70, "ExampleText",
 CellID->1419990459],
Cell[CellGroupData[{
Cell[7859, 270, 293, 9, 70, "Input",
 CellID->1541289730],
Cell[8155, 281, 1961, 59, 355, "Output",
 CellID->552612020]
}, Open  ]],
Cell[10131, 343, 96, 1, 70, "ExampleText",
 CellID->793875302],
Cell[CellGroupData[{
Cell[10252, 348, 537, 17, 70, "Input",
 CellID->2091818866],
Cell[10792, 367, 1954, 59, 396, "Output",
 CellID->8806918]
}, Open  ]],
Cell[12761, 429, 67, 1, 70, "ExampleText",
 CellID->346301903],
Cell[CellGroupData[{
Cell[12853, 434, 208, 6, 70, "Input",
 CellID->1703694510],
Cell[13064, 442, 2052, 61, 380, "Output",
 CellID->14604134]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15177, 510, 311, 9, 70, "SeeAlsoSection",
 CellID->12112],
Cell[15491, 521, 708, 26, 70, "SeeAlso",
 CellID->17910]
}, Open  ]],
Cell[16214, 550, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

