(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16573,        605]
NotebookOptionsPosition[     13438,        500]
NotebookOutlinePosition[     14706,        537]
CellTagsIndexPosition[     14621,        532]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PIE CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PieChart" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieChart"], 
         "PieStyle" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieStyle"], "Degree" :> 
         Documentation`HelpLookup["paclet:ref/Degree"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"PieChart\"\>", 2->"\<\"PieStyle\"\>", 
      3->"\<\"Degree\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PieOrientation", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PieOrientation"], "InlineFormula"],
     " \[LineSeparator]\:f3b5is an option for ",
     Cell[BoxData[
      ButtonBox["PieChart",
       BaseStyle->"Link",
       ButtonData->"paclet:PieCharts/ref/PieChart"]], "InlineFormula"],
     " that determines the placement of the first piece of data."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PieOrientation", "->", 
   StyleBox["\[Theta]", "TR"]}]], "InlineFormula"],
 " starts the pie chart along the angle \[Theta]. \[Theta]=0 corresponds to \
the positive x-axis, and increases in a counter-clockwise direction."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PieOrientation", "->", 
   StyleBox["dir", "TI"]}]], "InlineFormula"],
 " fills the pie chart in the specified direction. ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 " can be either ",
 Cell[BoxData["\"\<Clockwise\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<CounterClockwise\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->1717701951],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PieOrientation", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\[Theta]", "TR"], ",", 
     StyleBox["dir", "TI"]}], "}"}]}]], "InlineFormula"],
 " starts along the angle ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " and proceeds in the direction ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->695229194],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PieOrientation", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{"PieOrientation", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", " ", "\"\<CounterClockwise\>\""}], "}"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->258540231]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66072335],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->111494865],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->136860366],

Cell["\<\
The first pie wedge normally starts along the positive x-axis and proceeds in \
a counter-clockwise direction:\
\>", "ExampleText",
 CellID->1662592626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PieOrientation", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2084851257],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 8.377580409572781}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {8.377580409572781, 12.566370614359172`}]}}, {
    InsetBox["1", {0.3000000000000003, 0.519615242270663}], 
    InsetBox["2", {-0.30000000000000077`, -0.5196152422706627}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104331993]
}, Open  ]],

Cell["Start along the positive y-axis:", "ExampleText",
 CellID->137050418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PieOrientation", "\[Rule]", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1303905742],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.853981633974483, 9.948376736367678}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.948376736367678, 14.137166941154069`}]}}, {
    InsetBox["1", {-0.5196152422706632, 0.2999999999999999}], 
    InsetBox["2", {0.5196152422706632, -0.29999999999999993`}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->107630701]
}, Open  ]],

Cell["Proceed in a clockwise direction:", "ExampleText",
 CellID->1820671806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PieOrientation", "\[Rule]", "\"\<Clockwise\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->536557339],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {4.1887902047863905`, 6.283185307179586}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {0., 4.1887902047863905`}]}}, {
    InsetBox["1", {0.2999999999999996, -0.5196152422706634}], 
    InsetBox["2", {-0.2999999999999999, 0.5196152422706632}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->26474929]
}, Open  ]],

Cell["\<\
Start along the positive y-axis, and proceed in a clockwise direction:\
\>", "ExampleText",
 CellID->635362820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PieOrientation", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Pi", "/", "2"}], ",", "\"\<Clockwise\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1254222856],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {5.759586531581287, 7.853981633974483}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {1.5707963267948966`, 5.759586531581287}]}}, {
    InsetBox["1", {0.5196152422706634, 0.29999999999999954`}], 
    InsetBox["2", {-0.5196152422706632, -0.2999999999999998}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->389328694]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieChart",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PieOrientation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 47.5799850}", "context" -> "PieCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Pie Charts Package Symbol",
     "language" -> "en", "paclet" -> "PieCharts Package", "status" -> "None", 
    "summary" -> 
    "PieOrientation \\:f3b5is an option for PieChart that determines the \
placement of the first piece of data.", "synonyms" -> {}, "title" -> 
    "PieOrientation", "type" -> "Symbol", "uri" -> 
    "PieCharts/ref/PieOrientation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4081, 145, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66072335]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14479, 525}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 779, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1402, 45, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1462, 48, 543, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2042, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2520, 85, 299, 7, 70, "Notes",
 CellID->1067943069],
Cell[2822, 94, 408, 13, 70, "Notes",
 CellID->1717701951],
Cell[3233, 109, 418, 15, 70, "Notes",
 CellID->695229194],
Cell[3654, 126, 390, 14, 70, "Notes",
 CellID->258540231]
}, Closed]],
Cell[CellGroupData[{
Cell[4081, 145, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66072335],
Cell[CellGroupData[{
Cell[4465, 159, 148, 5, 70, "ExampleSection",
 CellID->111494865],
Cell[4616, 166, 132, 3, 70, "Input",
 CellID->136860366],
Cell[4751, 171, 162, 4, 70, "ExampleText",
 CellID->1662592626],
Cell[CellGroupData[{
Cell[4938, 179, 233, 7, 28, "Input",
 CellID->2084851257],
Cell[5174, 188, 1480, 51, 380, "Output",
 CellID->104331993]
}, Open  ]],
Cell[6669, 242, 75, 1, 70, "ExampleText",
 CellID->137050418],
Cell[CellGroupData[{
Cell[6769, 247, 251, 8, 70, "Input",
 CellID->1303905742],
Cell[7023, 257, 1481, 51, 380, "Output",
 CellID->107630701]
}, Open  ]],
Cell[8519, 311, 77, 1, 70, "ExampleText",
 CellID->1820671806],
Cell[CellGroupData[{
Cell[8621, 316, 243, 8, 70, "Input",
 CellID->536557339],
Cell[8867, 326, 1465, 51, 380, "Output",
 CellID->26474929]
}, Open  ]],
Cell[10347, 380, 121, 3, 70, "ExampleText",
 CellID->635362820],
Cell[CellGroupData[{
Cell[10493, 387, 323, 11, 70, "Input",
 CellID->1254222856],
Cell[10819, 400, 1481, 51, 380, "Output",
 CellID->389328694]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12361, 458, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12680, 469, 716, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[13411, 498, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

