(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13906,        475]
NotebookOptionsPosition[     11334,        389]
NotebookOutlinePosition[     12565,        425]
CellTagsIndexPosition[     12480,        420]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PIE CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PieChart" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieChart"], 
         "PieEdgeStyle" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieEdgeStyle"], 
         "PieLabels" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieLabels"], 
         "PieExploded" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieExploded"], 
         "RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], "Hue" :> 
         Documentation`HelpLookup["paclet:ref/Hue"], "Opacity" :> 
         Documentation`HelpLookup["paclet:ref/Opacity"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"PieChart\"\>", 2->"\<\"PieEdgeStyle\"\>", 
      3->"\<\"PieLabels\"\>", 4->"\<\"PieExploded\"\>", 5->"\<\"RGBColor\"\>",
       6->"\<\"Hue\"\>", 7->"\<\"Opacity\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PieStyle", "ObjectName",
 CellID->22815],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PieStyle"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PieChart",
       BaseStyle->"Link",
       ButtonData->"paclet:PieCharts/ref/PieChart"]], "InlineFormula"],
     " that specifies a style for each wedge of the pie chart."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->21964],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["style", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["style", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "styles to be used (cyclically) for the sequence of wedges", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "give each wedge a different color", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->29209],

Cell["Styles are applied to each pie wedge.", "Notes",
 CellID->3347]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105176766],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->3912709],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160871393],

Cell[TextData[{
 Cell[BoxData["PieChart"], "InlineFormula"],
 " automatically chooses colors for the wedges:"
}], "ExampleText",
 CellID->1888388196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594859021],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->940402373]
}, Open  ]],

Cell["Each wedge can be given its own style:", "ExampleText",
 CellID->788306750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "Yellow", ",", "Orange", ",", "Brown"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1244928907],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[1, 0.5, 0.5], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {RGBColor[1, 0.5, 0], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {RGBColor[0.6, 0.4, 0.2], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->221704051]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->591],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieChart",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieEdgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieEdgeStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieLabels"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieExploded",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieExploded"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24629]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PieStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 47.8143660}", "context" -> "PieCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Pie Charts Package Symbol",
     "language" -> "en", "paclet" -> "PieCharts Package", "status" -> "None", 
    "summary" -> 
    "PieStyle is an option for PieChart that specifies a style for each wedge \
of the pie chart.", "synonyms" -> {}, "title" -> "PieStyle", "type" -> 
    "Symbol", "uri" -> "PieCharts/ref/PieStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3947, 127, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->105176766]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12337, 413}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1222, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1845, 52, 46, 1, 70, "ObjectName",
 CellID->22815],
Cell[1894, 55, 525, 15, 70, "Usage",
 CellID->23759]
}, Open  ]],
Cell[CellGroupData[{
Cell[2456, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2934, 92, 68, 1, 70, "Notes",
 CellID->21964],
Cell[3005, 95, 833, 24, 70, "2ColumnTableMod",
 CellID->29209],
Cell[3841, 121, 69, 1, 70, "Notes",
 CellID->3347]
}, Closed]],
Cell[CellGroupData[{
Cell[3947, 127, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105176766],
Cell[CellGroupData[{
Cell[4332, 141, 146, 5, 70, "ExampleSection",
 CellID->3912709],
Cell[4481, 148, 132, 3, 70, "Input",
 CellID->160871393],
Cell[4616, 153, 149, 4, 70, "ExampleText",
 CellID->1888388196],
Cell[CellGroupData[{
Cell[4790, 161, 254, 7, 28, "Input",
 CellID->594859021],
Cell[5047, 170, 1869, 57, 380, "Output",
 CellID->940402373]
}, Open  ]],
Cell[6931, 230, 81, 1, 70, "ExampleText",
 CellID->788306750],
Cell[CellGroupData[{
Cell[7037, 235, 338, 10, 70, "Input",
 CellID->1244928907],
Cell[7378, 247, 1821, 57, 380, "Output",
 CellID->221704051]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9260, 311, 309, 9, 70, "SeeAlsoSection",
 CellID->591],
Cell[9572, 322, 1720, 62, 70, "SeeAlso",
 CellID->24629]
}, Open  ]],
Cell[11307, 387, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

