(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13497,        448]
NotebookOptionsPosition[     11473,        389]
NotebookOutlinePosition[     12774,        421]
CellTagsIndexPosition[     12731,        418]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Plot" :> Documentation`HelpLookup["paclet:ref/Plot"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "ShadowBox" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBox"], 
         "Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Plot\"\>", 
      2->"\<\"PlotLegend\"\>", 3->"\<\"ShadowBox\"\>", 
      4->"\<\"Tooltip\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Legend", "ObjectName",
 CellID->28587],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Legend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["box", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["text", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a legend with the specified boxes and text."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Legend", "[", 
       RowBox[{
        StyleBox["func", "TI"], ",", 
        StyleBox["num", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a legend by applying ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"],
     " to numbers between 0 and 1, incremented by the number of boxes ",
     Cell[BoxData[
      RowBox[{
       StyleBox["num", "TI"], "-", "1"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Legend", "[", 
       RowBox[{
        StyleBox["func", "TI"], ",", 
        StyleBox["num", "TI"], ",", 
        StyleBox["mintext", "TI"], ",", 
        StyleBox["maxtext", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]labels the first and last boxes with ",
     Cell[BoxData[
      StyleBox["mintext", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["maxtext", "TI"]], "InlineFormula"],
     " respectively."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["box", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are color directives (e.g. ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ") or a graphic."
}], "Notes",
 CellID->4207],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["text", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are strings, or strings with ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " wrappers."
}], "Notes",
 CellID->25027],

Cell[TextData[{
 "Function ",
 Cell[BoxData[
  StyleBox["func", "TI"]], "InlineFormula"],
 " should generate a color directive or graphic suitable for a ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["box", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in the legend."
}], "Notes",
 CellID->20768],

Cell["The following options can be given:", "Notes",
 CellID->16622],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendPosition",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendPosition"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", " ", 
      RowBox[{"-", "1"}]}], "}"}], Cell[
    "position of legend in relation to graphic", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendSize",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "length or {x,y} dimensions", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendShadow",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendShadow"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies shadow", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendTextSpace",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendTextSpace"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "space in the legend box for text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendTextDirection",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendTextDirection"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "direction",
     " ",
     "text",
     " ",
     "is",
     " ",
     "rotated,",
     " ",
     "as",
     " ",
     "in",
     " ",
     Cell[BoxData[
      ButtonBox["Text",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Text"]], "InlineFormula"],
     " ",
     "graphics",
     " ",
     "primitive"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendTextOffset",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendTextOffset"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "offset",
     " ",
     "of",
     " ",
     "text,",
     " ",
     "as",
     " ",
     "in",
     " ",
     Cell[BoxData[
      ButtonBox["Text",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Text"]], "InlineFormula"],
     " ",
     "graphics",
     " ",
     "primitive"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["label for legend", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendLabelSpace",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendLabelSpace"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "specifies space for ",
     Cell[BoxData[
      ButtonBox["LegendLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/LegendLabel"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendOrientation"], "Vertical", 
    Cell["direction in which key boxes are laid out", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the amount of space around each key box", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendBorder",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendBorder"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style of border of key boxes and text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendBorderSpace",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendBorderSpace"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], 
    RowBox[{
    Cell["specifies space around all boxes", "TableText"], "and", " ", 
     "text"}]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LegendBackground",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/LegendBackground"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style of the background", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->16390]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20455],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBox",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20334]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Legend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 56.1739550}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "Legend[{{box_1, text_1}, ...}, options] generates a legend with the \
specified boxes and text. Legend[func, num, options] generates a legend by \
applying func to numbers between 0 and 1, incremented by the number of boxes \
num - 1. Legend[func, num, mintext, maxtext, options] labels the first and \
last boxes with mintext and maxtext respectively.", "synonyms" -> {}, "title" -> 
    "Legend", "type" -> "Symbol", "uri" -> "PlotLegends/ref/Legend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 889, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1512, 47, 44, 1, 70, "ObjectName",
 CellID->28587],
Cell[1559, 50, 1899, 57, 70, "Usage",
 CellID->32556]
}, Open  ]],
Cell[CellGroupData[{
Cell[3495, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3973, 129, 330, 13, 70, "Notes",
 CellID->4207],
Cell[4306, 144, 333, 13, 70, "Notes",
 CellID->25027],
Cell[4642, 159, 305, 11, 70, "Notes",
 CellID->20768],
Cell[4950, 172, 68, 1, 70, "Notes",
 CellID->16622],
Cell[5021, 175, 5098, 158, 70, "3ColumnTableMod",
 CellID->16390]
}, Closed]],
Cell[CellGroupData[{
Cell[10156, 338, 311, 9, 70, "SeeAlsoSection",
 CellID->20455],
Cell[10470, 349, 961, 35, 70, "SeeAlso",
 CellID->20334]
}, Open  ]],
Cell[11446, 387, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

