(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21713,        538]
NotebookOptionsPosition[     19152,        453]
NotebookOutlinePosition[     20437,        490]
CellTagsIndexPosition[     20352,        485]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendBackground" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendBackground"], 
         "LegendBorderSpace" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendBorderSpace"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendBackground\"\>", 
      4->"\<\"LegendBorderSpace\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendBorder", "ObjectName",
 CellID->12366],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendBorder"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the style of the line surrounding key boxes and text \
in a legend."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13406]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LegendBorder", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that the border line style should use the specified graphics \
directive or list of directives."
}], "Notes",
 CellID->5525]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->661446599],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->461872800],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->474748138],

Cell["Use a black border around the legend:", "ExampleText",
 CellID->265786350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendBorder", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->593335174]
}, Open  ]],

Cell["Use a thick purple border around the legend:", "ExampleText",
 CellID->926346927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendBorder", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", " ", "Purple"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->305198690],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->412127488]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12945],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendBackground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendBackground"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendBorderSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendBorderSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendBorder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 54.5332880}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendBorder is an option for Legend, which specifies the style of the \
line surrounding key boxes and text in a legend.", "synonyms" -> {}, "title" -> 
    "LegendBorder", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendBorder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3034, 103, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->661446599]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20209, 478}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1000, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1623, 50, 50, 1, 70, "ObjectName",
 CellID->12366],
Cell[1676, 53, 556, 16, 70, "Usage",
 CellID->13406]
}, Open  ]],
Cell[CellGroupData[{
Cell[2269, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2747, 91, 250, 7, 70, "Notes",
 CellID->5525]
}, Closed]],
Cell[CellGroupData[{
Cell[3034, 103, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->661446599],
Cell[CellGroupData[{
Cell[3419, 117, 148, 5, 70, "ExampleSection",
 CellID->461872800],
Cell[3570, 124, 134, 3, 70, "Input",
 CellID->474748138],
Cell[3707, 129, 80, 1, 70, "ExampleText",
 CellID->265786350],
Cell[CellGroupData[{
Cell[3812, 134, 532, 16, 47, "Input",
 CellID->216563026],
Cell[4347, 152, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->593335174]
}, Open  ]],
Cell[10691, 263, 87, 1, 70, "ExampleText",
 CellID->926346927],
Cell[CellGroupData[{
Cell[10803, 268, 606, 18, 47, "Input",
 CellID->305198690],
Cell[11412, 288, 6300, 107, 265, "Output",
 Evaluatable->False,
 CellID->412127488]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17773, 402, 311, 9, 70, "SeeAlsoSection",
 CellID->12945],
Cell[18087, 413, 1023, 35, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[19125, 451, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

