(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22185,        551]
NotebookOptionsPosition[     19542,        464]
NotebookOutlinePosition[     20843,        501]
CellTagsIndexPosition[     20758,        496]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendBorder" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendBorder"], 
         "LegendLabelSpace" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendLabelSpace"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendBorder\"\>", 
      4->"\<\"LegendLabelSpace\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendBorderSpace", "ObjectName",
 CellID->17549],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendBorderSpace"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     " which sets the space around the entire set of key boxes and text in \
the legend."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->343],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell["a number", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "determine border spacing automatically", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->15085]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49996713],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->743186933],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->272350507],

Cell["Normal placement of the keys in the legend:", "ExampleText",
 CellID->371010699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendBorderSpace", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->487013620]
}, Open  ]],

Cell["\<\
Increase the space between the keys and the edges of the legend:\
\>", "ExampleText",
 CellID->1431790852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendBorderSpace", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1337476979],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43016082]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10904],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendBorder",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendBorder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendLabelSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendLabelSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1554584929]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendBorderSpace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 54.9239230}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendBorderSpace is an option for Legend which sets the space around \
the entire set of key boxes and text in the legend.", "synonyms" -> {}, 
    "title" -> "LegendBorderSpace", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendBorderSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3394, 113, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49996713]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20616, 489}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 985, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1608, 50, 55, 1, 70, "ObjectName",
 CellID->17549],
Cell[1666, 53, 557, 16, 70, "Usage",
 CellID->1559]
}, Open  ]],
Cell[CellGroupData[{
Cell[2260, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2738, 91, 67, 1, 70, "Notes",
 CellID->343],
Cell[2808, 94, 549, 14, 70, "2ColumnTableMod",
 CellID->15085]
}, Closed]],
Cell[CellGroupData[{
Cell[3394, 113, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49996713],
Cell[CellGroupData[{
Cell[3778, 127, 148, 5, 70, "ExampleSection",
 CellID->743186933],
Cell[3929, 134, 134, 3, 70, "Input",
 CellID->272350507],
Cell[4066, 139, 86, 1, 70, "ExampleText",
 CellID->371010699],
Cell[CellGroupData[{
Cell[4177, 144, 541, 16, 47, "Input",
 CellID->216563026],
Cell[4721, 162, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->487013620]
}, Open  ]],
Cell[11065, 273, 116, 3, 70, "ExampleText",
 CellID->1431790852],
Cell[CellGroupData[{
Cell[11206, 280, 534, 16, 47, "Input",
 CellID->1337476979],
Cell[11743, 298, 6364, 108, 265, "Output",
 Evaluatable->False,
 CellID->43016082]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18168, 413, 311, 9, 70, "SeeAlsoSection",
 CellID->10904],
Cell[18482, 424, 1018, 35, 70, "SeeAlso",
 CellID->1554584929]
}, Open  ]],
Cell[19515, 462, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

