(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22740,        574]
NotebookOptionsPosition[     20079,        485]
NotebookOutlinePosition[     21347,        522]
CellTagsIndexPosition[     21262,        517]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendLabelSpace" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendLabelSpace"], 
         "PlotLabel" :> Documentation`HelpLookup["paclet:ref/PlotLabel"], 
         "Labeled" :> Documentation`HelpLookup["paclet:ref/Labeled"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Legend\"\>", 
      2->"\<\"PlotLegend\"\>", 3->"\<\"LegendLabelSpace\"\>", 
      4->"\<\"PlotLabel\"\>", 5->"\<\"Labeled\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendLabel", "ObjectName",
 CellID->31242],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendLabel"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the text to be used as the label for the legend box. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17719]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->5317],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"\"\<\>", "string", "\"\<\>"}], "TI"], Cell[
    "a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no label", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->32656],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FontForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontForm"]], "InlineFormula"],
 " can be used to modify a string label ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"\"\<\>", "string"}], "TI"]], "InlineFormula"],
 "\"."
}], "Notes",
 CellID->11452]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49018895],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39860383],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->212813232],

Cell["Don't use a label with the legend:", "ExampleText",
 CellID->1112916497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", "  ",
    
   RowBox[{"LegendLabel", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1275848884],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5936561]
}, Open  ]],

Cell["Label the legend with some text:", "ExampleText",
 CellID->866339375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", "  ",
    
   RowBox[{"LegendLabel", "\[Rule]", "\"\<Curves\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1657977728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->848169638]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15184],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendLabelSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendLabelSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendLabel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 55.3614342}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendLabel is an option for Legend, which specifies the text to be used \
as the label for the legend box. ", "synonyms" -> {}, "title" -> 
    "LegendLabel", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendLabel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3730, 126, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49018895]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21120, 510}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1037, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1660, 49, 49, 1, 70, "ObjectName",
 CellID->31242],
Cell[1712, 52, 543, 16, 70, "Usage",
 CellID->17719]
}, Open  ]],
Cell[CellGroupData[{
Cell[2292, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2770, 90, 68, 1, 70, "Notes",
 CellID->5317],
Cell[2841, 93, 550, 15, 70, "2ColumnTableMod",
 CellID->32656],
Cell[3394, 110, 299, 11, 70, "Notes",
 CellID->11452]
}, Closed]],
Cell[CellGroupData[{
Cell[3730, 126, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49018895],
Cell[CellGroupData[{
Cell[4114, 140, 147, 5, 70, "ExampleSection",
 CellID->39860383],
Cell[4264, 147, 134, 3, 70, "Input",
 CellID->212813232],
Cell[4401, 152, 78, 1, 70, "ExampleText",
 CellID->1112916497],
Cell[CellGroupData[{
Cell[4504, 157, 532, 16, 47, "Input",
 CellID->1275848884],
Cell[5039, 175, 6327, 108, 265, "Output",
 Evaluatable->False,
 CellID->5936561]
}, Open  ]],
Cell[11381, 286, 75, 1, 70, "ExampleText",
 CellID->866339375],
Cell[CellGroupData[{
Cell[11481, 291, 542, 16, 47, "Input",
 CellID->1657977728],
Cell[12026, 309, 6398, 109, 265, "Output",
 Evaluatable->False,
 CellID->848169638]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18485, 425, 311, 9, 70, "SeeAlsoSection",
 CellID->15184],
Cell[18799, 436, 1238, 44, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[20052, 483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

