(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22694,        572]
NotebookOptionsPosition[     20074,        484]
NotebookOutlinePosition[     21304,        520]
CellTagsIndexPosition[     21219,        515]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendPosition" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendPosition"], 
         "LegendOrientation" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendOrientation"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendPosition\"\>", 
      4->"\<\"LegendOrientation\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendSize", "ObjectName",
 CellID->29626],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendSize"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     " which specifies the size of a legend box."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->31434],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "automatically determine the size of the box", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["number", "TI"], Cell["scales the size", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["xlength", "TI"], ",", 
      StyleBox["ylength", "TI"]}], "}"}], Cell[TextData[{
     "uses ",
     Cell[BoxData[
      StyleBox["xlength", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["ylength", "TI"]], "InlineFormula"],
     " to determine the size"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15564],

Cell[TextData[{
 "Using setting ",
 Cell[BoxData[
  StyleBox["number", "TI"]], "InlineFormula"],
 " ",
 "scales the size so that it fits in a box with a width equal to the longest \
side of the length given."
}], "Notes",
 CellID->27653]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24982353],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->51848167],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->32545995],

Cell["Normal-sized box for the legend:", "ExampleText",
 CellID->1901710765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendSize", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279414430]
}, Open  ]],

Cell["Use a smaller box for the legend:", "ExampleText",
 CellID->1053709054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendSize", "\[Rule]", "0.5"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->664747646],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->500687290]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17980],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendOrientation",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendOrientation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 57.6739934}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendSize is an option for Legend which specifies the size of a legend \
box.", "synonyms" -> {}, "title" -> "LegendSize", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4008, 135, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->24982353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21077, 508}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 994, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1617, 50, 48, 1, 70, "ObjectName",
 CellID->29626],
Cell[1668, 53, 509, 15, 70, "Usage",
 CellID->340]
}, Open  ]],
Cell[CellGroupData[{
Cell[2214, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2692, 90, 69, 1, 70, "Notes",
 CellID->31434],
Cell[2764, 93, 967, 27, 70, "2ColumnTableMod",
 CellID->15564],
Cell[3734, 122, 237, 8, 70, "Notes",
 CellID->27653]
}, Closed]],
Cell[CellGroupData[{
Cell[4008, 135, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24982353],
Cell[CellGroupData[{
Cell[4392, 149, 147, 5, 70, "ExampleSection",
 CellID->51848167],
Cell[4542, 156, 133, 3, 70, "Input",
 CellID->32545995],
Cell[4678, 161, 76, 1, 70, "ExampleText",
 CellID->1901710765],
Cell[CellGroupData[{
Cell[4779, 166, 534, 16, 47, "Input",
 CellID->216563026],
Cell[5316, 184, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->279414430]
}, Open  ]],
Cell[11660, 295, 77, 1, 70, "ExampleText",
 CellID->1053709054],
Cell[CellGroupData[{
Cell[11762, 300, 528, 16, 47, "Input",
 CellID->664747646],
Cell[12293, 318, 6345, 108, 265, "Output",
 Evaluatable->False,
 CellID->500687290]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18699, 433, 311, 9, 70, "SeeAlsoSection",
 CellID->17980],
Cell[19013, 444, 1019, 35, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[20047, 482, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

