(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22964,        576]
NotebookOptionsPosition[     20277,        487]
NotebookOutlinePosition[     21569,        524]
CellTagsIndexPosition[     21484,        519]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendLabelSpace" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendLabelSpace"], 
         "LegendPosition" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendPosition"], 
         "LegendOrientation" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendOrientation"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendLabelSpace\"\>", 4->"\<\"LegendPosition\"\>", 
      5->"\<\"LegendOrientation\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendSpacing", "ObjectName",
 CellID->18942],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendSpacing"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     " which specifies the amount of space around each key box on a scale \
where the box is 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19026]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->20394],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell["a number", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "determine spacing automatically", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->29909],

Cell[TextData[{
 "For the boxes to be adjacent (a continuous line, for instance) ",
 Cell[BoxData["LegendSpacing"], "InlineFormula"],
 " should be set to ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "Notes",
 CellID->19755]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->211384223],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->436170226],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->181136012],

Cell["Normally spaced keys in the legend:", "ExampleText",
 CellID->1886939853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendSpacing", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18160772]
}, Open  ]],

Cell[TextData[{
 "Increasing the value of ",
 Cell[BoxData["LegendSpacing"], "InlineFormula"],
 " increases the distance between the keys in the legend:"
}], "ExampleText",
 CellID->1907094122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendSpacing", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->348600837],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79624217]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23121],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendLabelSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendLabelSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendOrientation",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendOrientation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 2.5022420}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendSpacing is an option for Legend which specifies the amount of \
space around each key box on a scale where the box is 1.", "synonyms" -> {}, 
    "title" -> "LegendSpacing", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3771, 124, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->211384223]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21341, 512}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1136, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1759, 52, 51, 1, 70, "ObjectName",
 CellID->18942],
Cell[1813, 55, 561, 16, 70, "Usage",
 CellID->19026]
}, Open  ]],
Cell[CellGroupData[{
Cell[2411, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2889, 93, 69, 1, 70, "Notes",
 CellID->20394],
Cell[2961, 96, 542, 14, 70, "2ColumnTableMod",
 CellID->29909],
Cell[3506, 112, 228, 7, 70, "Notes",
 CellID->19755]
}, Closed]],
Cell[CellGroupData[{
Cell[3771, 124, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->211384223],
Cell[CellGroupData[{
Cell[4156, 138, 148, 5, 70, "ExampleSection",
 CellID->436170226],
Cell[4307, 145, 134, 3, 70, "Input",
 CellID->181136012],
Cell[4444, 150, 79, 1, 70, "ExampleText",
 CellID->1886939853],
Cell[CellGroupData[{
Cell[4548, 155, 529, 16, 47, "Input",
 CellID->216563026],
Cell[5080, 173, 6344, 108, 265, "Output",
 Evaluatable->False,
 CellID->18160772]
}, Open  ]],
Cell[11439, 284, 193, 5, 70, "ExampleText",
 CellID->1907094122],
Cell[CellGroupData[{
Cell[11657, 293, 531, 16, 47, "Input",
 CellID->348600837],
Cell[12191, 311, 6377, 109, 265, "Output",
 Evaluatable->False,
 CellID->79624217]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18629, 427, 311, 9, 70, "SeeAlsoSection",
 CellID->23121],
Cell[18943, 438, 1292, 44, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[20250, 485, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

