(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22329,        556]
NotebookOptionsPosition[     19723,        470]
NotebookOutlinePosition[     20992,        506]
CellTagsIndexPosition[     20907,        501]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendTextSpace" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendTextSpace"], 
         "LegendTextDirection" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendTextDirection"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendTextSpace\"\>", 
      4->"\<\"LegendTextDirection\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendTextOffset", "ObjectName",
 CellID->4473],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendTextOffset"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the offset of text next to the key box."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24837]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->28861],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "determine offset automatically", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["offset", "TI"], Cell[TextData[{
     "the same settings used in the ",
     Cell[BoxData[
      ButtonBox["Text",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Text"]], "InlineFormula"],
     " graphic primitive"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->7278]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->155791518],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->141940169],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->592150132],

Cell["Automatic placement of the text in the legend:", "ExampleText",
 CellID->1638565722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendTextOffset", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->988164651],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->850958033]
}, Open  ]],

Cell["Display the text below the lines in the legend:", "ExampleText",
 CellID->43800526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendTextOffset", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->315774460]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15598],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendTextSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendTextSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendTextDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendTextDirection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8929]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendTextOffset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 3.3616390}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendTextOffset is an option for Legend, which specifies the offset of \
text next to the key box.", "synonyms" -> {}, "title" -> "LegendTextOffset", 
    "type" -> "Symbol", "uri" -> "PlotLegends/ref/LegendTextOffset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3582, 119, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->155791518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20764, 494}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1003, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1626, 50, 53, 1, 70, "ObjectName",
 CellID->4473],
Cell[1682, 53, 532, 15, 70, "Usage",
 CellID->24837]
}, Open  ]],
Cell[CellGroupData[{
Cell[2251, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2729, 90, 69, 1, 70, "Notes",
 CellID->28861],
Cell[2801, 93, 744, 21, 70, "2ColumnTableMod",
 CellID->7278]
}, Closed]],
Cell[CellGroupData[{
Cell[3582, 119, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->155791518],
Cell[CellGroupData[{
Cell[3967, 133, 148, 5, 70, "ExampleSection",
 CellID->141940169],
Cell[4118, 140, 134, 3, 70, "Input",
 CellID->592150132],
Cell[4255, 145, 90, 1, 70, "ExampleText",
 CellID->1638565722],
Cell[CellGroupData[{
Cell[4370, 150, 540, 16, 47, "Input",
 CellID->988164651],
Cell[4913, 168, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->850958033]
}, Open  ]],
Cell[11257, 279, 89, 1, 70, "ExampleText",
 CellID->43800526],
Cell[CellGroupData[{
Cell[11371, 284, 583, 18, 47, "Input",
 CellID->216563026],
Cell[11957, 304, 6325, 108, 265, "Output",
 Evaluatable->False,
 CellID->315774460]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18343, 419, 311, 9, 70, "SeeAlsoSection",
 CellID->15598],
Cell[18657, 430, 1024, 35, 70, "SeeAlso",
 CellID->8929]
}, Open  ]],
Cell[19696, 468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

