(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8661,        311]
NotebookOptionsPosition[      6320,        234]
NotebookOutlinePosition[      7596,        271]
CellTagsIndexPosition[      7512,        266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ShadowBox" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBox"], 
         "ShadowBorder" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBorder"], 
         "ShadowOffset" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowOffset"], 
         "ShadowForeground" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/ShadowForeground"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ShadowBox\"\>", 2->"\<\"ShadowBorder\"\>", 
      3->"\<\"ShadowOffset\"\>", 
      4->"\<\"ShadowForeground\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShadowBackground", "ObjectName",
 CellID->15945],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ShadowBackground"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ShadowBox",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/ShadowBox"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the style for a drop shadow. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ShadowBackground", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " the style should be a color primitive."
}], "Notes",
 CellID->6792],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  StyleBox["style", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   StyleBox["0", "TR"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22791]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->251229349],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->157765620],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->132890505],

Cell["Color the background gray:", "ExampleText",
 CellID->1458018162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowBackground", "\[Rule]", "Gray"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1419097921],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], RectangleBox[{0.1, -0.1}]}, 
   {GrayLevel[1], RectangleBox[{0, 0}]}, 
   {GrayLevel[0], Thickness[0.001], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->639044692]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15991],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBox",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBorder",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBorder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowOffset",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowOffset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowForeground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowForeground"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15565]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShadowBackground - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 4.3616646}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "ShadowBackground is an option for ShadowBox or Legend, which specifies \
the style for a drop shadow. ", "synonyms" -> {}, "title" -> 
    "ShadowBackground", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/ShadowBackground"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3424, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->251229349]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7369, 259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1000, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1623, 50, 54, 1, 70, "ObjectName",
 CellID->15945],
Cell[1680, 53, 684, 20, 70, "Usage",
 CellID->32283]
}, Open  ]],
Cell[CellGroupData[{
Cell[2401, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2879, 95, 197, 7, 70, "Notes",
 CellID->6792],
Cell[3079, 104, 308, 13, 70, "Notes",
 CellID->22791]
}, Closed]],
Cell[CellGroupData[{
Cell[3424, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->251229349],
Cell[CellGroupData[{
Cell[3809, 136, 148, 5, 70, "ExampleSection",
 CellID->157765620],
Cell[3960, 143, 134, 3, 70, "Input",
 CellID->132890505],
Cell[4097, 148, 70, 1, 70, "ExampleText",
 CellID->1458018162],
Cell[CellGroupData[{
Cell[4192, 153, 328, 11, 28, "Input",
 CellID->1419097921],
Cell[4523, 166, 357, 10, 201, "Output",
 CellID->639044692]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4941, 183, 311, 9, 70, "SeeAlsoSection",
 CellID->15991],
Cell[5255, 194, 1023, 35, 70, "SeeAlso",
 CellID->15565]
}, Open  ]],
Cell[6293, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

