(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9682,        345]
NotebookOptionsPosition[      7120,        260]
NotebookOutlinePosition[      8401,        297]
CellTagsIndexPosition[      8317,        292]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ShadowBox" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBox"], 
         "ShadowBorder" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBorder"], 
         "ShadowBackground" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBackground"], 
         "ShadowOffset" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowOffset"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"ShadowBox\"\>", 
      2->"\<\"ShadowBorder\"\>", 3->"\<\"ShadowBackground\"\>", 
      4->"\<\"ShadowOffset\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShadowForeground", "ObjectName",
 CellID->20588],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ShadowForeground"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ShadowBox",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/ShadowBox"]], "InlineFormula"],
     ", which specifies a style for the foreground of a shadow box. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12269]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If used from ",
 Cell[BoxData[
  ButtonBox["Legend",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
 ", this will be the style behind the keys and text."
}], "Notes",
 CellID->24826],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ShadowForeground", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " setting ",
 Cell[BoxData[
  StyleBox["style", "TI"]], "InlineFormula"],
 " should be a color primitive."
}], "Notes",
 CellID->13331]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->451828273],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->467290327],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->833069037],

Cell["Color the foreground yellow:", "ExampleText",
 CellID->1458018162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowForeground", "\[Rule]", "Yellow"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1419097921],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.1, -0.1}]}, 
   {RGBColor[1, 1, 0], RectangleBox[{0, 0}]}, 
   {GrayLevel[0], Thickness[0.001], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373882812]
}, Open  ]],

Cell["Color the foreground yellow with opacity:", "ExampleText",
 CellID->311270162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowForeground", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.8", "]"}], ",", "Yellow"}], "]"}]}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->247448642],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.1, -0.1}]}, 
   {RGBColor[1, 1, 0], Opacity[0.8], RectangleBox[{0, 0}], 
    {GrayLevel[0], Thickness[0.001], 
     LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1857859896]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11831],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBox",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBorder",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBorder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBackground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBackground"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowOffset",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowOffset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15565]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShadowForeground - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 4.9085536}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "ShadowForeground is an option for ShadowBox, which specifies a style for \
the foreground of a shadow box. ", "synonyms" -> {}, "title" -> 
    "ShadowForeground", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/ShadowForeground"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3274, 114, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->451828273]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8174, 285}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 990, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1613, 49, 54, 1, 70, "ObjectName",
 CellID->20588],
Cell[1670, 52, 543, 15, 70, "Usage",
 CellID->12269]
}, Open  ]],
Cell[CellGroupData[{
Cell[2250, 72, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2728, 89, 243, 8, 70, "Notes",
 CellID->24826],
Cell[2974, 99, 263, 10, 70, "Notes",
 CellID->13331]
}, Closed]],
Cell[CellGroupData[{
Cell[3274, 114, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->451828273],
Cell[CellGroupData[{
Cell[3659, 128, 148, 5, 70, "ExampleSection",
 CellID->467290327],
Cell[3810, 135, 134, 3, 70, "Input",
 CellID->833069037],
Cell[3947, 140, 72, 1, 70, "ExampleText",
 CellID->1458018162],
Cell[CellGroupData[{
Cell[4044, 145, 331, 11, 28, "Input",
 CellID->1419097921],
Cell[4378, 158, 360, 10, 201, "Output",
 CellID->373882812]
}, Open  ]],
Cell[4753, 171, 84, 1, 70, "ExampleText",
 CellID->311270162],
Cell[CellGroupData[{
Cell[4862, 176, 438, 14, 70, "Input",
 CellID->247448642],
Cell[5303, 192, 377, 10, 201, "Output",
 CellID->1857859896]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5741, 209, 311, 9, 70, "SeeAlsoSection",
 CellID->11831],
Cell[6055, 220, 1023, 35, 70, "SeeAlso",
 CellID->15565]
}, Open  ]],
Cell[7093, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

