(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9407,        336]
NotebookOptionsPosition[      6914,        253]
NotebookOutlinePosition[      8180,        290]
CellTagsIndexPosition[      8096,        285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ShadowBox" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBox"], 
         "ShadowBorder" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBorder"], 
         "ShadowBackground" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBackground"], 
         "ShadowForeground" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/ShadowForeground"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ShadowBox\"\>", 2->"\<\"ShadowBorder\"\>", 
      3->"\<\"ShadowBackground\"\>", 
      4->"\<\"ShadowForeground\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShadowOffset", "ObjectName",
 CellID->26479],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ShadowOffset"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ShadowBox",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/ShadowBox"]], "InlineFormula"],
     ", which sets the offset of a shadow from the rest of the box. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->102]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ShadowOffset", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies the x and y offset distances."
}], "Notes",
 CellID->9375]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716748752],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->686298475],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->213862508],

Cell["\<\
Offset the shadow by one-tenth of the width and height of the box:\
\>", "ExampleText",
 CellID->1458018162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowOffset", "\[Rule]", "0.1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1419097921],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.1, 0.1}]}, 
   {GrayLevel[1], RectangleBox[{0, 0}]}, 
   {GrayLevel[0], Thickness[0.001], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2122836464]
}, Open  ]],

Cell["\<\
Offset the shadow to the bottom-right by one-quarter of the width and height \
of the box:\
\>", "ExampleText",
 CellID->570175384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowOffset", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", 
       RowBox[{"-", "0.25"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->219139190],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.25, -0.25}]}, 
   {GrayLevel[1], RectangleBox[{0, 0}]}, 
   {GrayLevel[0], Thickness[0.001], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->747506962]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16558],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBox",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBorder",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBorder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBackground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBackground"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowForeground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowForeground"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15565]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShadowOffset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 10.5336976}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "ShadowOffset is an option for ShadowBox, which sets the offset of a \
shadow from the rest of the box. ", "synonyms" -> {}, "title" -> 
    "ShadowOffset", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/ShadowOffset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3030, 104, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->716748752]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7953, 278}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1012, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1635, 50, 50, 1, 70, "ObjectName",
 CellID->26479],
Cell[1688, 53, 537, 15, 70, "Usage",
 CellID->102]
}, Open  ]],
Cell[CellGroupData[{
Cell[2262, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2740, 90, 253, 9, 70, "Notes",
 CellID->9375]
}, Closed]],
Cell[CellGroupData[{
Cell[3030, 104, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716748752],
Cell[CellGroupData[{
Cell[3415, 118, 148, 5, 70, "ExampleSection",
 CellID->686298475],
Cell[3566, 125, 134, 3, 70, "Input",
 CellID->213862508],
Cell[3703, 130, 118, 3, 70, "ExampleText",
 CellID->1458018162],
Cell[CellGroupData[{
Cell[3846, 137, 321, 10, 28, "Input",
 CellID->1419097921],
Cell[4170, 149, 355, 10, 201, "Output",
 CellID->2122836464]
}, Open  ]],
Cell[4540, 162, 141, 4, 70, "ExampleText",
 CellID->570175384],
Cell[CellGroupData[{
Cell[4706, 170, 400, 13, 70, "Input",
 CellID->219139190],
Cell[5109, 185, 357, 10, 201, "Output",
 CellID->747506962]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5527, 202, 311, 9, 70, "SeeAlsoSection",
 CellID->16558],
Cell[5841, 213, 1031, 35, 70, "SeeAlso",
 CellID->15565]
}, Open  ]],
Cell[6887, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

