(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25664,        751]
NotebookOptionsPosition[     22706,        657]
NotebookOutlinePosition[     24186,        696]
CellTagsIndexPosition[     24101,        691]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYHEDRON OPERATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronOperations" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PolyhedronOperations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronData" :> 
          Documentation`HelpLookup["paclet:ref/PolyhedronData"], "Stellate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Stellate"], "Truncate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Truncate"], "OpenTruncate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/OpenTruncate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolyhedronData\"\>", 
       2->"\<\"Stellate\"\>", 3->"\<\"Truncate\"\>", 
       4->"\<\"OpenTruncate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Geodesate", "ObjectName",
 CellID->18578],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Geodesate", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]replaces each polygon in graphics expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by the projection onto the circumscribed sphere of the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " regular tessellation of that polygon."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Geodesate", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["z", "TI"]}], "}"}], ",", 
        StyleBox["radius", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]does the projection onto the sphere of radius ",
     Cell[BoxData[
      StyleBox["radius", "TI"]], "InlineFormula"],
     " centered at ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Geodesate", "[", 
   RowBox[{
    RowBox[{
     ButtonBox["PolyhedronData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyhedronData"], "[", 
     StyleBox["poly", "TI"], "]"}], ",", " ", "n"}], "]"}]], 
  "InlineFormula"],
 " creates a geodesated polyhedron."
}], "Notes",
 CellID->19516],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must be an positive integer."
}], "Notes",
 CellID->804033216]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->782995311],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->209509732],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PolyhedronOperations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->916961981],

Cell[TextData[{
 Cell[BoxData["Geodesate"], "InlineFormula"],
 " works on graphics primitives:"
}], "ExampleText",
 CellID->590121926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Geodesate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1212219481],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       FractionBox["1", 
        SqrtBox["3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       FractionBox["1", 
        SqrtBox["3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       FractionBox["1", 
        SqrtBox["3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       FractionBox["1", 
        SqrtBox["3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "2"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["3"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"11", ",", "13", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "14", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "15", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "11", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "15", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "18", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"18", ",", "19", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "11", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "19", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "22", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"22", ",", "13", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "11", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "22", ",", "24"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"22", ",", "25", ",", "24"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"25", ",", "14", ",", "24"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "13", ",", "24"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"25", ",", "22", ",", "27"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"22", ",", "19", ",", "27"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "18", ",", "27"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"18", ",", "25", ",", "27"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "25", ",", "29"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"25", ",", "18", ",", "29"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"18", ",", "15", ",", "29"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "14", ",", "29"}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{581, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1812878876]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["Geodesate"], "InlineFormula"],
 " also works on graphics objects:"
}], "ExampleText",
 CellID->1099728436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Geodesate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Cube\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1891557770],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->937283443]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8273],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stellate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Stellate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Truncate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Truncate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenTruncate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30101]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2650],

Cell[TextData[ButtonBox["PolyhedronOperations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]], "Tutorials",
 CellID->17225]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Geodesate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 11.3618438}", "context" -> 
    "PolyhedronOperations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Polyhedron Operations Package Symbol", "language" -> "en", "paclet" -> 
    "PolyhedronOperations Package", "status" -> "None", "summary" -> 
    "Geodesate[expr, n] replaces each polygon in graphics expression expr by \
the projection onto the circumscribed sphere of the order n regular \
tessellation of that polygon. Geodesate[expr, n, {x, y, z}, radius] does the \
projection onto the sphere of radius radius centered at {x, y, z}.", 
    "synonyms" -> {}, "title" -> "Geodesate", "type" -> "Symbol", "uri" -> 
    "PolyhedronOperations/ref/Geodesate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4813, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->782995311]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23958, 684}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1637, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2260, 67, 47, 1, 70, "ObjectName",
 CellID->18578],
Cell[2310, 70, 1466, 44, 70, "Usage",
 CellID->20313]
}, Open  ]],
Cell[CellGroupData[{
Cell[3813, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4291, 136, 344, 12, 70, "Notes",
 CellID->19516],
Cell[4638, 150, 138, 5, 70, "Notes",
 CellID->804033216]
}, Closed]],
Cell[CellGroupData[{
Cell[4813, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->782995311],
Cell[CellGroupData[{
Cell[5198, 174, 148, 5, 70, "ExampleSection",
 CellID->209509732],
Cell[5349, 181, 145, 4, 70, "Input",
 CellID->916961981],
Cell[5497, 187, 134, 4, 70, "ExampleText",
 CellID->590121926],
Cell[CellGroupData[{
Cell[5656, 195, 222, 7, 28, "Input",
 CellID->1212219481],
Cell[5881, 204, 6877, 227, 290, "Output",
 CellID->1812878876]
}, Open  ]],
Cell[12773, 434, 137, 4, 70, "ExampleText",
 CellID->1099728436],
Cell[CellGroupData[{
Cell[12935, 442, 227, 7, 28, "Input",
 CellID->1891557770],
Cell[13165, 451, 7573, 128, 216, "Output",
 Evaluatable->False,
 CellID->937283443]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20799, 586, 310, 9, 70, "SeeAlsoSection",
 CellID->8273],
Cell[21112, 597, 1024, 35, 70, "SeeAlso",
 CellID->30101]
}, Open  ]],
Cell[CellGroupData[{
Cell[22173, 637, 313, 9, 70, "TutorialsSection",
 CellID->2650],
Cell[22489, 648, 175, 4, 70, "Tutorials",
 CellID->17225]
}, Open  ]],
Cell[22679, 655, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

