(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20019,        601]
NotebookOptionsPosition[     17150,        507]
NotebookOutlinePosition[     18497,        544]
CellTagsIndexPosition[     18412,        539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYHEDRON OPERATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronOperations" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PolyhedronOperations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronData" :> 
          Documentation`HelpLookup["paclet:ref/PolyhedronData"], "Geodesate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Geodesate"], "Truncate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Truncate"], "OpenTruncate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/OpenTruncate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolyhedronData\"\>", 
       2->"\<\"Geodesate\"\>", 3->"\<\"Truncate\"\>", 
       4->"\<\"OpenTruncate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Stellate", "ObjectName",
 CellID->8972],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Stellate", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]replaces each polygon in graphics expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by a pyramid with the polygon as its base."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Stellate", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["ratio", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses a stellation ratio ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31884]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Stellate", "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " uses a stellation ratio of ",
 Cell[BoxData["2"], "InlineFormula"],
 "."
}], "Notes",
 CellID->10334],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Stellate", "[", 
   RowBox[{
    ButtonBox["PolyhedronData",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PolyhedronData"], "[", 
    StyleBox["poly", "TI"], "]"}], "]"}]], "InlineFormula"],
 " creates a stellated polyhedron."
}], "Notes",
 CellID->26084],

Cell[TextData[{
 "Stellation ratios less than ",
 Cell[BoxData[
  StyleBox["1", "TR"]], "InlineFormula"],
 " give concave figures."
}], "Notes",
 CellID->27793]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100700686],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->68382536],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PolyhedronOperations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->142139732],

Cell[TextData[{
 Cell[BoxData["Stellate"], "InlineFormula"],
 " works on graphics primitives:"
}], "ExampleText",
 CellID->590121926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1212219481],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"9", ",", "8", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "4", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "2", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "6", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "8", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "6", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "5", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "7", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "8", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "7", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "4", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "4", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "3", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "3", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "7", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "5", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "1", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "6", ",", "2"}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{496, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1420464584]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["Stellate"], "InlineFormula"],
 " also works on graphics objects:"
}], "ExampleText",
 CellID->1099728436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Dodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1891557770],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43006710]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20138],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Geodesate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Truncate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Truncate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenTruncate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19097]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21563],

Cell[TextData[ButtonBox["PolyhedronOperations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]], "Tutorials",
 CellID->15833]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Stellate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 12.0181106}", "context" -> 
    "PolyhedronOperations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Polyhedron Operations Package Symbol", "language" -> "en", "paclet" -> 
    "PolyhedronOperations Package", "status" -> "None", "summary" -> 
    "Stellate[expr] replaces each polygon in graphics expression expr by a \
pyramid with the polygon as its base. Stellate[expr, ratio] uses a stellation \
ratio ratio.", "synonyms" -> {}, "title" -> "Stellate", "type" -> "Symbol", 
    "uri" -> "PolyhedronOperations/ref/Stellate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4406, 151, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->100700686]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18269, 532}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1640, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2263, 67, 45, 1, 70, "ObjectName",
 CellID->8972],
Cell[2311, 70, 856, 26, 70, "Usage",
 CellID->31884]
}, Open  ]],
Cell[CellGroupData[{
Cell[3204, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3682, 118, 216, 8, 70, "Notes",
 CellID->10334],
Cell[3901, 128, 305, 10, 70, "Notes",
 CellID->26084],
Cell[4209, 140, 160, 6, 70, "Notes",
 CellID->27793]
}, Closed]],
Cell[CellGroupData[{
Cell[4406, 151, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100700686],
Cell[CellGroupData[{
Cell[4791, 165, 147, 5, 70, "ExampleSection",
 CellID->68382536],
Cell[4941, 172, 145, 4, 70, "Input",
 CellID->142139732],
Cell[5089, 178, 133, 4, 70, "ExampleText",
 CellID->590121926],
Cell[CellGroupData[{
Cell[5247, 186, 193, 5, 28, "Input",
 CellID->1212219481],
Cell[5443, 193, 4146, 128, 176, "Output",
 CellID->1420464584]
}, Open  ]],
Cell[9604, 324, 136, 4, 70, "ExampleText",
 CellID->1099728436],
Cell[CellGroupData[{
Cell[9765, 332, 209, 6, 28, "Input",
 CellID->1891557770],
Cell[9977, 340, 5201, 89, 201, "Output",
 Evaluatable->False,
 CellID->43006710]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15239, 436, 311, 9, 70, "SeeAlsoSection",
 CellID->20138],
Cell[15553, 447, 1026, 35, 70, "SeeAlso",
 CellID->19097]
}, Open  ]],
Cell[CellGroupData[{
Cell[16616, 487, 314, 9, 70, "TutorialsSection",
 CellID->21563],
Cell[16933, 498, 175, 4, 70, "Tutorials",
 CellID->15833]
}, Open  ]],
Cell[17123, 505, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

