(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8498,        284]
NotebookOptionsPosition[      6776,        228]
NotebookOutlinePosition[      7798,        257]
CellTagsIndexPosition[      7755,        254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYTOPES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polytopes Package" :> 
          Documentation`HelpLookup["paclet:Polytopes/tutorial/Polytopes"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Polytopes Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberOfVertices" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfVertices"], 
          "NumberOfEdges" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfEdges"], 
          "NumberOfFaces" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfFaces"], 
          "Area" :> Documentation`HelpLookup["paclet:Polytopes/ref/Area"], 
          "Faces" :> Documentation`HelpLookup["paclet:Polytopes/ref/Faces"], 
          "InscribedRadius" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/InscribedRadius"], 
          "CircumscribedRadius" :> 
          Documentation`HelpLookup[
           "paclet:Polytopes/ref/CircumscribedRadius"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NumberOfVertices\"\>", 
       2->"\<\"NumberOfEdges\"\>", 3->"\<\"NumberOfFaces\"\>", 
       4->"\<\"Area\"\>", 5->"\<\"Faces\"\>", 6->"\<\"InscribedRadius\"\>", 
       7->"\<\"CircumscribedRadius\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Vertices", "ObjectName",
 CellID->21476],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Vertices", "[", 
       StyleBox["polytope", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the vertex coordinates of ",
     Cell[BoxData[
      StyleBox["polytope", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10182]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Edges are not necessarily normalized to unit length.", "Notes",
 CellID->5321],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberOfVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfVertices"], "[", 
   StyleBox["polytope", "TI"], "]"}]], "InlineFormula"],
 " gives the number of vertices of ",
 Cell[BoxData[
  StyleBox["polytope", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24632]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15426],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfVertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfFaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfFaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Area",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Area"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Faces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Faces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/InscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircumscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/CircumscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->65644499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8501],

Cell[TextData[ButtonBox["Polytopes Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Polytopes/tutorial/Polytopes"]], "Tutorials",
 CellID->9293]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 34.5030612}", "context" -> "Polytopes`", 
    "keywords" -> {}, "index" -> True, "label" -> "Polytopes Package Symbol", 
    "language" -> "en", "paclet" -> "Polytopes Package", "status" -> "None", 
    "summary" -> 
    "Vertices[polytope] gives a list of the vertex coordinates of polytope. ",
     "synonyms" -> {}, "title" -> "Vertices", "type" -> "Symbol", "uri" -> 
    "Polytopes/ref/Vertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1963, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2586, 71, 46, 1, 70, "ObjectName",
 CellID->21476],
Cell[2635, 74, 486, 15, 70, "Usage",
 CellID->10182]
}, Open  ]],
Cell[CellGroupData[{
Cell[3158, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3636, 111, 84, 1, 70, "Notes",
 CellID->5321],
Cell[3723, 114, 354, 12, 70, "Notes",
 CellID->24632]
}, Closed]],
Cell[CellGroupData[{
Cell[4114, 131, 311, 9, 70, "SeeAlsoSection",
 CellID->15426],
Cell[4428, 142, 1807, 62, 70, "SeeAlso",
 CellID->65644499]
}, Open  ]],
Cell[CellGroupData[{
Cell[6272, 209, 313, 9, 70, "TutorialsSection",
 CellID->8501],
Cell[6588, 220, 146, 3, 70, "Tutorials",
 CellID->9293]
}, Open  ]],
Cell[6749, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

