(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14846,        493]
NotebookOptionsPosition[     12001,        402]
NotebookOutlinePosition[     13494,        441]
CellTagsIndexPosition[     13451,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYTOPES PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Area" :> Documentation`HelpLookup["paclet:Polytopes/ref/Area"], 
         "CircumscribedRadius" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/CircumscribedRadius"],
          "Decagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Decagon"], "Digon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Digon"], "Dodecagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Dodecagon"], "Faces" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Faces"], "Heptagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Heptagon"], "Hexagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Hexagon"], 
         "InscribedRadius" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/InscribedRadius"], 
         "Nonagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Nonagon"], 
         "NumberOfEdges" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfEdges"], 
         "NumberOfFaces" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfFaces"], 
         "NumberOfVertices" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfVertices"], 
         "Octagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Octagon"], "Pentagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Pentagon"], 
         "Undecagon" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Undecagon"], 
         "Vertices" :> 
         Documentation`HelpLookup["paclet:Polytopes/ref/Vertices"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Area\"\>", 
      2->"\<\"CircumscribedRadius\"\>", 3->"\<\"Decagon\"\>", 
      4->"\<\"Digon\"\>", 5->"\<\"Dodecagon\"\>", 6->"\<\"Faces\"\>", 
      7->"\<\"Heptagon\"\>", 8->"\<\"Hexagon\"\>", 
      9->"\<\"InscribedRadius\"\>", 10->"\<\"Nonagon\"\>", 
      11->"\<\"NumberOfEdges\"\>", 12->"\<\"NumberOfFaces\"\>", 
      13->"\<\"NumberOfVertices\"\>", 14->"\<\"Octagon\"\>", 
      15->"\<\"Pentagon\"\>", 16->"\<\"Undecagon\"\>", 
      17->"\<\"Vertices\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Polytopes Package", "Title",
 CellID->27229],

Cell[TextData[{
 "This package contains functions that give geometrical characteristics of \
regular polygons. Polygons are identified by name (",
 Cell[BoxData[
  ButtonBox["Digon",
   BaseStyle->"Link",
   ButtonData->"paclet:Polytopes/ref/Digon"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Decagon",
   BaseStyle->"Link",
   ButtonData->"paclet:Polytopes/ref/Decagon"]], "InlineFormula"],
 ", etc.) in function arguments and in results. "
}], "Text",
 CellID->23299],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NumberOfVertices",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/NumberOfVertices"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "number of vertices in polygon ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberOfEdges",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/NumberOfEdges"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "number of edges in polygon ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberOfFaces",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/NumberOfFaces"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "number of faces in polygon ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Vertices",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/Vertices"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "list of vertex coordinates for polygon ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Area",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/Area"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "area of polygon ",
     StyleBox["p", "TI"],
     " when edges have unit length "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InscribedRadius",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/InscribedRadius"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "radius of the inscribed circle of polygon ",
     StyleBox["p", "TI"],
     " when edges have unit length "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CircumscribedRadius",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/CircumscribedRadius"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "radius of the circumscribed circle of polygon ",
     StyleBox["p", "TI"],
     " when edges have unit length "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Faces",
      BaseStyle->"Link",
      ButtonData->"paclet:Polytopes/ref/Faces"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "list of faces from vertex numbers for polygon ",
     StyleBox["p", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21451],

Cell["Geometrical characteristics of polygons. ", "Caption",
 CellID->8947],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Digon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Digon"], Cell[
    "polygon with 2 edges ", "TableText"]},
   {"Triangle", Cell["polygon with 3 edges ", "TableText"]},
   {"Square", Cell["polygon with 4 edges ", "TableText"]},
   {
    ButtonBox["Pentagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Pentagon"], Cell[
    "polygon with 5 edges ", "TableText"]},
   {
    ButtonBox["Hexagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Hexagon"], Cell[
    "polygon with 6 edges ", "TableText"]},
   {
    ButtonBox["Heptagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Heptagon"], Cell[
    "polygon with 7 edges ", "TableText"]},
   {
    ButtonBox["Octagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Octagon"], Cell[
    "polygon with 8 edges ", "TableText"]},
   {
    ButtonBox["Nonagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Nonagon"], Cell[
    "polygon with 9 edges ", "TableText"]},
   {
    ButtonBox["Decagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Decagon"], Cell[
    "polygon with 10 edges ", "TableText"]},
   {
    ButtonBox["Undecagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Undecagon"], Cell[
    "polygon with 11 edges ", "TableText"]},
   {
    ButtonBox["Dodecagon",
     BaseStyle->"Link",
     ButtonData->"paclet:Polytopes/ref/Dodecagon"], Cell[
    "polygon with 12 edges ", "TableText"]}
  }]], "DefinitionBox",
 CellID->31724],

Cell["Names of polygons. ", "Caption",
 CellID->1250],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["Area",
   BaseStyle->"Link",
   ButtonData->"paclet:Polytopes/ref/Area"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InscribedRadius",
   BaseStyle->"Link",
   ButtonData->"paclet:Polytopes/ref/InscribedRadius"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["CircumscribedRadius",
   BaseStyle->"Link",
   ButtonData->"paclet:Polytopes/ref/CircumscribedRadius"]], 
  "InlineFormula"],
 " give information for a polygon with edges of length 1. The list of \
coordinates returned by ",
 Cell[BoxData[
  ButtonBox["Vertices",
   BaseStyle->"Link",
   ButtonData->"paclet:Polytopes/ref/Vertices"]], "InlineFormula"],
 " is conventional for the specified polygon and does not necessarily \
correspond to a polygon with unit edge length. "
}], "Text",
 CellID->14543],

Cell["This loads the package. ", "MathCaption",
 CellID->20809],

Cell[BoxData[
 RowBox[{"<<", "Polytopes`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18702],

Cell["An octagon has 8 edges. ", "MathCaption",
 CellID->17491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberOfEdges", "[", "Octagon", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30773],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23281]
}, Open  ]],

Cell["\<\
This is the area of an octagon when the length of each edge is 1. \
\>", "MathCaption",
 CellID->26479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Area", "[", "Octagon", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->102],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cot", "[", 
   FractionBox["\[Pi]", "8"], "]"}]}]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16827]
}, Open  ]],

Cell["\<\
These points represent the coordinates of the vertices of an octagon. \
\>", "MathCaption",
 CellID->10564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Vertices", "[", "Octagon", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{382, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9961]
}, Open  ]],

Cell["Here is a plot of the vertices of an octagon. ", "MathCaption",
 CellID->1590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.05", "]"}], ",", " ", 
     RowBox[{"Point", " ", "/@", " ", "%"}]}], "}"}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16558],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.05], PointBox[{2^Rational[-1, 2], 2^Rational[-1, 2]}], 
   PointBox[{0, 1}], PointBox[{-2^Rational[-1, 2], 2^Rational[-1, 2]}], 
   PointBox[{-1, 0}], PointBox[{-2^Rational[-1, 2], -2^Rational[-1, 2]}], 
   PointBox[{0, -1}], PointBox[{2^Rational[-1, 2], -2^Rational[-1, 2]}], 
   PointBox[{1, 0}]},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{364, 361},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->491]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polytopes Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 34.6749406}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Polytopes Package Tutorial", "language" -> "en", "paclet" -> 
    "Polytopes Package", "status" -> "None", "summary" -> 
    "This package contains functions that give geometrical characteristics of \
regular polygons. Polygons are identified by name (Digon, Decagon, etc.) in \
function arguments and in results. Geometrical characteristics of polygons. \
Names of polygons. ", "synonyms" -> {}, "title" -> "Polytopes Package", 
    "type" -> "Tutorial", "uri" -> "Polytopes/tutorial/Polytopes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2491, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3116, 74, 50, 1, 70, "Title",
 CellID->27229],
Cell[3169, 77, 481, 14, 70, "Text",
 CellID->23299],
Cell[3653, 93, 2378, 77, 70, "DefinitionBox",
 CellID->21451],
Cell[6034, 172, 75, 1, 70, "Caption",
 CellID->8947],
Cell[6112, 175, 1578, 49, 70, "DefinitionBox",
 CellID->31724],
Cell[7693, 226, 53, 1, 70, "Caption",
 CellID->1250],
Cell[7749, 229, 847, 26, 70, "Text",
 CellID->14543],
Cell[8599, 257, 63, 1, 70, "MathCaption",
 CellID->20809],
Cell[8665, 260, 93, 3, 70, "Input",
 CellID->18702],
Cell[8761, 265, 63, 1, 70, "MathCaption",
 CellID->17491],
Cell[CellGroupData[{
Cell[8849, 270, 111, 3, 70, "Input",
 CellID->30773],
Cell[8963, 275, 154, 5, 36, "Output",
 CellID->23281]
}, Open  ]],
Cell[9132, 283, 113, 3, 70, "MathCaption",
 CellID->26479],
Cell[CellGroupData[{
Cell[9270, 290, 100, 3, 70, "Input",
 CellID->102],
Cell[9373, 295, 232, 8, 49, "Output",
 CellID->16827]
}, Open  ]],
Cell[9620, 306, 117, 3, 70, "MathCaption",
 CellID->10564],
Cell[CellGroupData[{
Cell[9762, 313, 106, 3, 70, "Input",
 CellID->19286],
Cell[9871, 318, 1105, 45, 89, "Output",
 CellID->9961]
}, Open  ]],
Cell[10991, 366, 84, 1, 70, "MathCaption",
 CellID->1590],
Cell[CellGroupData[{
Cell[11100, 371, 305, 9, 70, "Input",
 CellID->16558],
Cell[11408, 382, 539, 14, 382, "Output",
 CellID->491]
}, Open  ]]
}, Open  ]],
Cell[11974, 400, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

