(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15030,        570]
NotebookOptionsPosition[     11027,        431]
NotebookOutlinePosition[     12377,        468]
CellTagsIndexPosition[     12292,        463]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PRIMALITY PROVING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Primality Proving Package" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/tutorial/PrimalityProving"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Primality Proving Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ProvablePrimeQ" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/ref/ProvablePrimeQ"], "PrimeQCertificate" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/ref/PrimeQCertificate"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ProvablePrimeQ\"\>", 
       2->"\<\"PrimeQCertificate\"\>", 
       3->"\<\"PrimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrimeQCertificateCheck", "ObjectName",
 CellID->21608],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PrimeQCertificateCheck", "[", 
       RowBox[{
        StyleBox["cert", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["cert", "TI"]], "InlineFormula"],
     " is a valid certificate for the primality or compositeness of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20388]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PrimeQCertificateCheck"], "InlineFormula"],
 " recognizes whether ",
 Cell[BoxData[
  StyleBox["cert", "TI"]], "InlineFormula"],
 " is a primality or compositeness certification, and then uses the \
certificate to verify the assertion."
}], "Notes",
 CellID->11931],

Cell[TextData[{
 "The certificate ",
 Cell[BoxData[
  StyleBox["cert", "TI"]], "InlineFormula"],
 " should match the integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13727]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84460067],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->559307117],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->196547709],

Cell["A certificate of primality:", "ExampleText",
 CellID->25366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", "1093", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1093", ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{517, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31402]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->19313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificateCheck", "[", 
  RowBox[{"%", ",", "1093"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14274],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26588],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->337110605],

Cell["A certificate of compositeness:", "ExampleText",
 CellID->9745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", "3837523", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3837522", ",", "3837523"}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11914]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->16440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificateCheck", "[", 
  RowBox[{"%", ",", "3837523"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31821],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8726],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->316214603],

Cell[TextData[{
 "A certificate need not come from ",
 Cell[BoxData["PrimeQCertificate"], "InlineFormula"],
 ". Here is the certificate generated by ",
 Cell[BoxData["PrimeQCertificate"], "InlineFormula"],
 " for ",
 Cell[BoxData["3837523"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c1", "=", 
  RowBox[{"PrimeQCertificate", "[", "3837523", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3837522", ",", "3837523"}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30715]
}, Open  ]],

Cell[TextData[{
 "A different certificate asserting that ",
 Cell[BoxData["3837523"], "InlineFormula"],
 " is composite:"
}], "ExampleText",
 CellID->14708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2", "=", 
  RowBox[{"{", 
   RowBox[{"1488665", ",", "2", ",", "3837523"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11069],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1488665", ",", "2", ",", "3837523"}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10870]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->2432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificateCheck", "[", 
  RowBox[{"c2", ",", "3837523"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1781],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27852]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11523],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProvablePrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQCertificate",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13063],

Cell[TextData[ButtonBox["Primality Proving Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PrimalityProving/tutorial/PrimalityProving"]], "Tutorials",
 CellID->18662]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrimeQCertificateCheck - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 35.0343248}", "context" -> 
    "PrimalityProving`", "keywords" -> {}, "index" -> True, "label" -> 
    "Primality Proving Package Symbol", "language" -> "en", "paclet" -> 
    "PrimalityProving Package", "status" -> "None", "summary" -> 
    "PrimeQCertificateCheck[cert, n] gives True if cert is a valid \
certificate for the primality or compositeness of n, and False otherwise.", 
    "synonyms" -> {}, "title" -> "PrimeQCertificateCheck", "type" -> "Symbol",
     "uri" -> "PrimalityProving/ref/PrimeQCertificateCheck"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4199, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->84460067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12150, 456}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1505, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2128, 65, 60, 1, 70, "ObjectName",
 CellID->21608],
Cell[2191, 68, 939, 30, 70, "Usage",
 CellID->20388]
}, Open  ]],
Cell[CellGroupData[{
Cell[3167, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3645, 120, 296, 8, 70, "Notes",
 CellID->11931],
Cell[3944, 130, 218, 9, 70, "Notes",
 CellID->13727]
}, Closed]],
Cell[CellGroupData[{
Cell[4199, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84460067],
Cell[CellGroupData[{
Cell[4583, 158, 148, 5, 70, "ExampleSection",
 CellID->559307117],
Cell[4734, 165, 141, 4, 70, "Input",
 CellID->196547709],
Cell[4878, 171, 66, 1, 70, "ExampleText",
 CellID->25366],
Cell[CellGroupData[{
Cell[4969, 176, 111, 3, 28, "Input",
 CellID->3258],
Cell[5083, 181, 823, 27, 36, "Output",
 CellID->31402]
}, Open  ]],
Cell[5921, 211, 45, 1, 70, "ExampleText",
 CellID->19313],
Cell[CellGroupData[{
Cell[5991, 216, 140, 4, 70, "Input",
 CellID->14274],
Cell[6134, 222, 156, 5, 36, "Output",
 CellID->2958]
}, Open  ]],
Cell[6305, 230, 121, 3, 70, "ExampleDelimiter",
 CellID->26588],
Cell[6429, 235, 141, 4, 70, "Input",
 CellID->337110605],
Cell[6573, 241, 69, 1, 70, "ExampleText",
 CellID->9745],
Cell[CellGroupData[{
Cell[6667, 246, 114, 3, 70, "Input",
 CellID->9097],
Cell[6784, 251, 222, 7, 36, "Output",
 CellID->11914]
}, Open  ]],
Cell[7021, 261, 45, 1, 70, "ExampleText",
 CellID->16440],
Cell[CellGroupData[{
Cell[7091, 266, 143, 4, 70, "Input",
 CellID->31821],
Cell[7237, 272, 156, 5, 36, "Output",
 CellID->6434]
}, Open  ]],
Cell[7408, 280, 120, 3, 70, "ExampleDelimiter",
 CellID->8726],
Cell[7531, 285, 141, 4, 70, "Input",
 CellID->316214603],
Cell[7675, 291, 299, 9, 70, "ExampleText",
 CellID->12501],
Cell[CellGroupData[{
Cell[7999, 304, 139, 4, 70, "Input",
 CellID->28658],
Cell[8141, 310, 222, 7, 36, "Output",
 CellID->30715]
}, Open  ]],
Cell[8378, 320, 156, 5, 70, "ExampleText",
 CellID->14708],
Cell[CellGroupData[{
Cell[8559, 329, 158, 5, 70, "Input",
 CellID->11069],
Cell[8720, 336, 222, 7, 36, "Output",
 CellID->10870]
}, Open  ]],
Cell[8957, 346, 44, 1, 70, "ExampleText",
 CellID->2432],
Cell[CellGroupData[{
Cell[9026, 351, 143, 4, 70, "Input",
 CellID->1781],
Cell[9172, 357, 157, 5, 36, "Output",
 CellID->27852]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9390, 369, 311, 9, 70, "SeeAlsoSection",
 CellID->11523],
Cell[9704, 380, 755, 26, 70, "SeeAlso",
 CellID->9086]
}, Open  ]],
Cell[CellGroupData[{
Cell[10496, 411, 314, 9, 70, "TutorialsSection",
 CellID->13063],
Cell[10813, 422, 172, 4, 70, "Tutorials",
 CellID->18662]
}, Open  ]],
Cell[11000, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

