(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9463,        317]
NotebookOptionsPosition[      6207,        226]
NotebookOutlinePosition[      7767,        262]
CellTagsIndexPosition[      7724,        259]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Quaternions Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Quaternion",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/Quaternion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " represent a quaternion by its coefficients"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToQuaternion",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/ToQuaternion"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromQuaternion",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/FromQuaternion"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->735974301],

Cell["\t", "GuideDelimiter",
 CellID->774530318],

Cell[TextData[{
 Cell[TextData[ButtonBox["QuaternionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/QuaternionQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnitQuaternionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/UnitQuaternionQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerQuaternionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/IntegerQuaternionQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ScalarQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/ScalarQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->886153009],

Cell["\t", "GuideDelimiter",
 CellID->1588528759],

Cell[TextData[{
 Cell[TextData[ButtonBox["AbsIJK",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/AbsIJK"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " absolute value of the pure quaternion part of a quaternion"
}], "GuideText",
 CellID->463248880],

Cell[TextData[{
 Cell[TextData[ButtonBox["AdjustedSignIJK",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/AdjustedSignIJK"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " adjusted sign of the pure quaternion part"
}], "GuideText",
 CellID->1195705785],

Cell["\t", "GuideDelimiter",
 CellID->1045170162],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeftAssociates",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/LeftAssociates"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the 24 left associates of a quaternion"
}], "GuideText",
 CellID->1906163921],

Cell[TextData[{
 Cell[TextData[ButtonBox["RightAssociates",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/RightAssociates"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the 24 right associates of a quaternion"
}], "GuideText",
 CellID->528105688],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimaryLeftAssociate",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/PrimaryLeftAssociate"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the left associate with the largest scalar component"
}], "GuideText",
 CellID->322385165],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimaryRightAssociate",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/PrimaryRightAssociate"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the right associate with the largest scalar component"
}], "GuideText",
 CellID->226226774],

Cell["\t", "GuideDelimiter",
 CellID->1147335428],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeftGCD",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/LeftGCD"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " greatest common left divisor of two quaternions"
}], "GuideText",
 CellID->1010871983],

Cell[TextData[{
 Cell[TextData[ButtonBox["RightGCD",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/RightGCD"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " greatest common right divisor"
}], "GuideText",
 CellID->982286864]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Packages for Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PackagesForSymbolicMathematics"]], "GuideTutorial",
 CellID->164417897],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/tutorial/Quaternions"]], "GuideTutorial",
 CellID->593981236]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAbout",
 CellID->169572785],

Cell[TextData[ButtonBox["Numerical Evaluation and Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "GuideMoreAbout",
 CellID->274883678]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quaternions Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 36.0656012}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Quaternions Package Guide",
     "language" -> "en", "paclet" -> "Quaternions Package", "status" -> 
    "None", "summary" -> 
    "Quaternion -- represent a quaternion by its coefficients, AbsIJK -- \
absolute value of the pure quaternion part of a quaternion, AdjustedSignIJK \
-- adjusted sign of the pure quaternion part, LeftAssociates -- the 24 left \
associates of a quaternion, RightAssociates -- the 24 right associates of a \
quaternion, PrimaryLeftAssociate -- the left associate with the largest \
scalar component, PrimaryRightAssociate -- the right associate with the \
largest scalar component, LeftGCD -- greatest common left divisor of two \
quaternions, RightGCD -- greatest common right divisor", "synonyms" -> {}, 
    "title" -> "Quaternions Package", "type" -> "Guide", "uri" -> 
    "Quaternions/guide/QuaternionsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[683, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[742, 31, 282, 8, 70, "GuideText",
 CellID->203374175],
Cell[1027, 41, 443, 12, 70, "InlineGuideFunctionListing",
 CellID->735974301],
Cell[1473, 55, 48, 1, 70, "GuideDelimiter",
 CellID->774530318],
Cell[1524, 58, 904, 25, 70, "InlineGuideFunctionListing",
 CellID->886153009],
Cell[2431, 85, 49, 1, 70, "GuideDelimiter",
 CellID->1588528759],
Cell[2483, 88, 290, 8, 70, "GuideText",
 CellID->463248880],
Cell[2776, 98, 295, 9, 70, "GuideText",
 CellID->1195705785],
Cell[3074, 109, 49, 1, 70, "GuideDelimiter",
 CellID->1045170162],
Cell[3126, 112, 290, 9, 70, "GuideText",
 CellID->1906163921],
Cell[3419, 123, 292, 9, 70, "GuideText",
 CellID->528105688],
Cell[3714, 134, 315, 9, 70, "GuideText",
 CellID->322385165],
Cell[4032, 145, 318, 9, 70, "GuideText",
 CellID->226226774],
Cell[4353, 156, 49, 1, 70, "GuideDelimiter",
 CellID->1147335428],
Cell[4405, 159, 282, 8, 70, "GuideText",
 CellID->1010871983],
Cell[4690, 169, 265, 8, 70, "GuideText",
 CellID->982286864]
}, Open  ]],
Cell[CellGroupData[{
Cell[4992, 182, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5057, 185, 185, 4, 70, "GuideTutorial",
 CellID->164417897],
Cell[5245, 191, 161, 3, 70, "GuideTutorial",
 CellID->593981236]
}, Open  ]],
Cell[CellGroupData[{
Cell[5443, 199, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5508, 202, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[5668, 207, 146, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5817, 212, 160, 3, 70, "GuideMoreAbout",
 CellID->169572785],
Cell[5980, 217, 185, 4, 70, "GuideMoreAbout",
 CellID->274883678]
}, Open  ]],
Cell[6180, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

