(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5820,        197]
NotebookOptionsPosition[      4299,        150]
NotebookOutlinePosition[      5367,        179]
CellTagsIndexPosition[      5324,        176]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["QUATERNIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quaternions Package" :> 
          Documentation`HelpLookup[
           "paclet:Quaternions/tutorial/Quaternions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quaternions Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quaternion" :> 
          Documentation`HelpLookup["paclet:Quaternions/ref/Quaternion"], 
          "ToQuaternion" :> 
          Documentation`HelpLookup["paclet:Quaternions/ref/ToQuaternion"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Quaternion\"\>", 
       2->"\<\"ToQuaternion\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromQuaternion", "ObjectName",
 CellID->3684],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromQuaternion", "[", 
       StyleBox["q", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]transforms the ",
     Cell[BoxData[
      ButtonBox["Quaternion",
       BaseStyle->"Link",
       ButtonData->"paclet:Quaternions/ref/Quaternion"]], "InlineFormula"],
     " object ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " to the symbolic form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       RowBox[{"I", " ", 
        StyleBox["b", "TI"]}], "+", 
       RowBox[{"J", " ", 
        StyleBox["c", "TI"]}], "+", 
       RowBox[{"K", " ", 
        StyleBox["d", "TI"]}]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24390],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/Quaternion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToQuaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/ToQuaternion"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15199]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17906],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/tutorial/Quaternions"]], "Tutorials",
 CellID->25928]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromQuaternion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 42.6282692}", "context" -> "Quaternions`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Quaternions Package Symbol", "language" -> "en", "paclet" -> 
    "Quaternions Package", "status" -> "None", "summary" -> 
    "FromQuaternion[q] transforms the Quaternion object q to the symbolic \
form a + I b + J c + K d.", "synonyms" -> {}, "title" -> "FromQuaternion", 
    "type" -> "Symbol", "uri" -> "Quaternions/ref/FromQuaternion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1316, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1939, 60, 51, 1, 70, "ObjectName",
 CellID->3684],
Cell[1993, 63, 919, 30, 70, "Usage",
 CellID->9168]
}, Open  ]],
Cell[CellGroupData[{
Cell[2949, 98, 311, 9, 70, "SeeAlsoSection",
 CellID->24390],
Cell[3263, 109, 487, 17, 70, "SeeAlso",
 CellID->15199]
}, Open  ]],
Cell[CellGroupData[{
Cell[3787, 131, 314, 9, 70, "TutorialsSection",
 CellID->17906],
Cell[4104, 142, 153, 3, 70, "Tutorials",
 CellID->25928]
}, Open  ]],
Cell[4272, 148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

