(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6111,        204]
NotebookOptionsPosition[      4599,        157]
NotebookOutlinePosition[      5652,        186]
CellTagsIndexPosition[      5609,        183]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["QUATERNIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quaternions Package" :> 
          Documentation`HelpLookup[
           "paclet:Quaternions/tutorial/Quaternions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quaternions Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UnitQuaternions" :> 
          Documentation`HelpLookup["paclet:Quaternions/ref/UnitQuaternions"], 
          "QuaternionQ" :> 
          Documentation`HelpLookup["paclet:Quaternions/ref/QuaternionQ"], 
          "IntegerQuaternionQ" :> 
          Documentation`HelpLookup[
           "paclet:Quaternions/ref/IntegerQuaternionQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"UnitQuaternions\"\>", 2->"\<\"QuaternionQ\"\>", 
       3->"\<\"IntegerQuaternionQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnitQuaternionQ", "ObjectName",
 CellID->18792],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UnitQuaternionQ", "[", 
       StyleBox["q", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " is a unit quaternion and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28211],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitQuaternions",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/UnitQuaternions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuaternionQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/QuaternionQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQuaternionQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/IntegerQuaternionQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->488058389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12933],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/tutorial/Quaternions"]], "Tutorials",
 CellID->30137]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnitQuaternionQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 51.4409948}", "context" -> "Quaternions`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Quaternions Package Symbol", "language" -> "en", "paclet" -> 
    "Quaternions Package", "status" -> "None", "summary" -> 
    "UnitQuaternionQ[q] gives True if q is a unit quaternion and False \
otherwise.", "synonyms" -> {}, "title" -> "UnitQuaternionQ", "type" -> 
    "Symbol", "uri" -> "Quaternions/ref/UnitQuaternionQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1489, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2112, 63, 53, 1, 70, "ObjectName",
 CellID->18792],
Cell[2168, 66, 755, 25, 70, "Usage",
 CellID->16193]
}, Open  ]],
Cell[CellGroupData[{
Cell[2960, 96, 311, 9, 70, "SeeAlsoSection",
 CellID->28211],
Cell[3274, 107, 776, 26, 70, "SeeAlso",
 CellID->488058389]
}, Open  ]],
Cell[CellGroupData[{
Cell[4087, 138, 314, 9, 70, "TutorialsSection",
 CellID->12933],
Cell[4404, 149, 153, 3, 70, "Tutorials",
 CellID->30137]
}, Open  ]],
Cell[4572, 155, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

