(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11246,        393]
NotebookOptionsPosition[      8534,        306]
NotebookOutlinePosition[      9887,        343]
CellTagsIndexPosition[      9803,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RSquared" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/RSquared"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RSquared\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AdjustedRSquared", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["AdjustedRSquared"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option to ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents the adjusted coefficient of determination."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AdjustedRSquared"], "InlineFormula"],
 " gives a modified version of the coefficient of determination ",
 Cell[BoxData[
  ButtonBox["RSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RSquared"]], "InlineFormula"],
 " which adjusts for the number of parameters in the model."
}], "Notes",
 CellID->360107398],

Cell[TextData[{
 Cell[BoxData["AdjustedRSquared"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["n", "TI"], "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["n", "TI"], "-", 
       StyleBox["p", "TI"]}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      ButtonBox["RSquared",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RSquared"]}], ")"}]}]}]], 
  "InlineFormula"],
 " where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "=", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["data", "TI"], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is the number of parameters in the model."
}], "Notes",
 CellID->207946374]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->577299389],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->228133326],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->93536150],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["AdjustedRSquared"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RSquared"]], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"AdjustedRSquared", ",", "RSquared"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->249755488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9786297031091596`"}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9810041805414752`"}]}], "}"}]], "Output",\

 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->478330747]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RSquared"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AdjustedRSquared - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 58.7068058}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "AdjustedRSquared is a possible value for the RegressionReport option to \
Regress and DesignedRegress which represents the adjusted coefficient of \
determination.", "synonyms" -> {}, "title" -> "AdjustedRSquared", "type" -> 
    "Symbol", "uri" -> "RegressionCommon/ref/AdjustedRSquared"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4706, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->577299389]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9660, 331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1255, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1878, 61, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1940, 64, 938, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2915, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3393, 113, 365, 9, 70, "Notes",
 CellID->360107398],
Cell[3761, 124, 908, 34, 70, "Notes",
 CellID->207946374]
}, Closed]],
Cell[CellGroupData[{
Cell[4706, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->577299389],
Cell[CellGroupData[{
Cell[5091, 177, 148, 5, 70, "ExampleSection",
 CellID->228133326],
Cell[5242, 184, 140, 4, 70, "Input",
 CellID->93536150],
Cell[5385, 190, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[5438, 193, 937, 26, 70, "Input",
 CellID->26500],
Cell[6378, 221, 276, 9, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6679, 234, 345, 11, 70, "Input",
 CellID->249755488],
Cell[7027, 247, 324, 10, 36, "Output",
 CellID->478330747]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7412, 264, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7731, 275, 217, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7985, 286, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8306, 297, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8507, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

