(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7434,        248]
NotebookOptionsPosition[      5514,        190]
NotebookOutlinePosition[      6728,        221]
CellTagsIndexPosition[      6685,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AsymptoticCovarianceMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/AsymptoticCovarianceMatrix"], 
          "CorrelationMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CorrelationMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AsymptoticCovarianceMatrix\"\>", 
       2->"\<\"CorrelationMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AsymptoticCorrelationMatrix", "ObjectName",
 CellID->4643],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["AsymptoticCorrelationMatrix"], "InlineFormula"],
     " \[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["NonlinearRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
      "InlineFormula"],
     " which represents the estimated correlation matrix of the fit \
parameters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The estimated correlation matrix is based on the linear approximation to the \
fitted nonlinear model.\
\>", "Notes",
 CellID->28253],

Cell[TextData[{
 Cell[BoxData["AsymptoticCovarianceMatrix"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["J", "\[Transpose]"], "J"}], ")"}], 
   RowBox[{"-", "1"}]]], "InlineFormula"],
 " where ",
 Cell[BoxData["J"], "InlineFormula"],
 " is the design matrix for the linear model approximation."
}], "Notes",
 CellID->50804685]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19560],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AsymptoticCovarianceMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/AsymptoticCovarianceMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CorrelationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CorrelationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17852],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->28505]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AsymptoticCorrelationMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 59.0193138}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "AsymptoticCorrelationMatrix is a possible value for the RegressionReport \
option for NonlinearRegress which represents the estimated correlation matrix \
of the fit parameters.", "synonyms" -> {}, "title" -> 
    "AsymptoticCorrelationMatrix", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/AsymptoticCorrelationMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1481, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2104, 65, 64, 1, 70, "ObjectName",
 CellID->4643],
Cell[2171, 68, 803, 23, 70, "Usage",
 CellID->21700]
}, Open  ]],
Cell[CellGroupData[{
Cell[3011, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3489, 113, 143, 4, 70, "Notes",
 CellID->28253],
Cell[3635, 119, 407, 13, 70, "Notes",
 CellID->50804685]
}, Closed]],
Cell[CellGroupData[{
Cell[4079, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->19560],
Cell[4393, 148, 543, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[4973, 170, 314, 9, 70, "TutorialsSection",
 CellID->17852],
Cell[5290, 181, 182, 4, 70, "Tutorials",
 CellID->28505]
}, Open  ]],
Cell[5487, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

