(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7622,        255]
NotebookOptionsPosition[      5709,        197]
NotebookOutlinePosition[      6918,        228]
CellTagsIndexPosition[      6875,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AsymptoticCorrelationMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"], 
          "CovarianceMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CovarianceMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AsymptoticCorrelationMatrix\"\>", 
       2->"\<\"CovarianceMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AsymptoticCovarianceMatrix", "ObjectName",
 CellID->9387],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["AsymptoticCovarianceMatrix"], "InlineFormula"],
     " \[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["NonlinearRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
      "InlineFormula"],
     " which represents the estimated covariance matrix of the fit \
parameters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31394]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The estimated covariance matrix is based on the linear approximation to the \
fitted nonlinear model.\
\>", "Notes",
 CellID->28253],

Cell[TextData[{
 Cell[BoxData["AsymptoticCovarianceMatrix"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["\[Sigma]", "TR"], "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["J", "\[Transpose]"], "J"}], ")"}], 
    RowBox[{"-", "1"}]]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["\[Sigma]", "TR"], "2"]], "InlineFormula"],
 " is the estimated variance and ",
 Cell[BoxData["J"], "InlineFormula"],
 " is the design matrix for the linear model approximation."
}], "Notes",
 CellID->50804685]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11741],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AsymptoticCorrelationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CovarianceMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->686],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->23414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AsymptoticCovarianceMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 59.1911932}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "AsymptoticCovarianceMatrix is a possible value for the RegressionReport \
option for NonlinearRegress which represents the estimated covariance matrix \
of the fit parameters.", "synonyms" -> {}, "title" -> 
    "AsymptoticCovarianceMatrix", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/AsymptoticCovarianceMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1481, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2104, 65, 63, 1, 70, "ObjectName",
 CellID->9387],
Cell[2170, 68, 801, 23, 70, "Usage",
 CellID->31394]
}, Open  ]],
Cell[CellGroupData[{
Cell[3008, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3486, 113, 142, 4, 70, "Notes",
 CellID->28253],
Cell[3631, 119, 608, 20, 70, "Notes",
 CellID->50804685]
}, Closed]],
Cell[CellGroupData[{
Cell[4276, 144, 311, 9, 70, "SeeAlsoSection",
 CellID->11741],
Cell[4590, 155, 543, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[5170, 177, 312, 9, 70, "TutorialsSection",
 CellID->686],
Cell[5485, 188, 182, 4, 70, "Tutorials",
 CellID->23414]
}, Open  ]],
Cell[5682, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

