(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11963,        405]
NotebookOptionsPosition[      9290,        319]
NotebookOutlinePosition[     10666,        357]
CellTagsIndexPosition[     10581,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Correlation" :> 
          Documentation`HelpLookup["paclet:ref/Correlation"], 
          "CovarianceMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CovarianceMatrix"], 
          "AsymptoticCorrelationMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"], 
          "EigenstructureTable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/EigenstructureTable"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Correlation\"\>", 
       2->"\<\"CovarianceMatrix\"\>", 
       3->"\<\"AsymptoticCorrelationMatrix\"\>", 
       4->"\<\"EigenstructureTable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CorrelationMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CorrelationMatrix"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents the estimated correlation matrix of the fit \
parameters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In the regression report, the correlation matrix has the ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " wrapper."
}], "Notes",
 CellID->19912]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375877660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->686538460],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["CorrelationMatrix"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "CorrelationMatrix", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CorrelationMatrix", "\[Rule]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", 
        RowBox[{"-", "0.8003511984213928`"}]},
       {
        RowBox[{"-", "0.8003511984213926`"}], "0.9999999999999998`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{309, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18793720]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Correlation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Correlation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CovarianceMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AsymptoticCorrelationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EigenstructureTable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/EigenstructureTable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CorrelationMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 6.9101408}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "CorrelationMatrix is a possible value for the RegressionReport option \
for Regress and DesignedRegress which represents the estimated correlation \
matrix of the fit parameters.", "synonyms" -> {}, "title" -> 
    "CorrelationMatrix", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/CorrelationMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4219, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->375877660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10438, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1784, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2407, 72, 60, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2470, 75, 955, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3462, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3940, 125, 242, 8, 70, "Notes",
 CellID->19912]
}, Closed]],
Cell[CellGroupData[{
Cell[4219, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375877660],
Cell[CellGroupData[{
Cell[4604, 152, 148, 5, 70, "ExampleSection",
 CellID->686538460],
Cell[4755, 159, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4899, 165, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4952, 168, 937, 26, 70, "Input",
 CellID->26500],
Cell[5892, 196, 131, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6048, 204, 309, 9, 70, "Input",
 CellID->26645265],
Cell[6360, 215, 886, 26, 49, "Output",
 CellID->18793720]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7307, 248, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7626, 259, 1078, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8741, 299, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9062, 310, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9263, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

