(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10940,        363]
NotebookOptionsPosition[      8834,        301]
NotebookOutlinePosition[     10156,        334]
CellTagsIndexPosition[     10113,        331]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipsoidQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuantile"], 
          "EllipsoidQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuartiles"], 
          "ParameterConfidenceRegion" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/ParameterConfidenceRegion"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"EllipsoidQuantile\"\>", 
       2->"\<\"EllipsoidQuartiles\"\>", 
       3->"\<\"ParameterConfidenceRegion\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ellipsoid", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Ellipsoid", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["p", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "-dimensional ellipsoid centered at the point ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["p", "TI"]]}], "}"}]], "InlineFormula"],
     " with semi-axis radii ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " aligned with the coordinate axes."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Ellipsoid", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["p", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["p", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "-dimensional ellipsoid with semi-axis radii ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " aligned with the direction ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Elliposid"], "InlineFormula"],
 " is used to represent ellipsoidal regions such as ",
 Cell[BoxData[
  ButtonBox["EllipsoidQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EllipsoidQuartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->28703],

Cell[TextData[{
 "Two-dimensional ",
 Cell[BoxData["Ellipsoid"], "InlineFormula"],
 " objects can be plotted using ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23811],

Cell[TextData[{
 "If the direction matrix ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["p", "TI"]]}], "}"}]], "InlineFormula"],
 " is a permutation of the identity matrix, the direction matrix is \
automatically dropped, reordering the radii if necessary."
}], "Notes",
 CellID->31322]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterConfidenceRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ellipsoid - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 7.7851632}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "Ellipsoid[{x_1, ..., x_p}, {r_1, ..., r_p}] represents a p-dimensional \
ellipsoid centered at the point {x_1, ..., x_p} with semi-axis radii r_i \
aligned with the coordinate axes. Ellipsoid[{x_1, ..., x_p}, {r_1, ..., r_p}, \
{d_1, ..., d_p}] represents a p-dimensional ellipsoid with semi-axis radii \
r_i aligned with the direction d_i.", "synonyms" -> {}, "title" -> 
    "Ellipsoid", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/Ellipsoid"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1665, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2288, 69, 52, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2343, 72, 2971, 95, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5351, 172, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5829, 189, 488, 16, 70, "Notes",
 CellID->28703],
Cell[6320, 207, 270, 10, 70, "Notes",
 CellID->23811],
Cell[6593, 219, 464, 15, 70, "Notes",
 CellID->31322]
}, Closed]],
Cell[CellGroupData[{
Cell[7094, 239, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7413, 250, 835, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8285, 281, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8606, 292, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8807, 299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

