(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6688,        225]
NotebookOptionsPosition[      4841,        168]
NotebookOutlinePosition[      5989,        198]
CellTagsIndexPosition[      5946,        195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FitCurvatureTable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/FitCurvatureTable"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"FitCurvatureTable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParameterBias", "ObjectName",
 CellID->32069],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ParameterBias"], "InlineFormula"],
     " \[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["NonlinearRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
      "InlineFormula"],
     " which represents the the estimated bias in the parameter estimates."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4322]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ParameterBias"], "InlineFormula"],
 " gives a vector of the estimated differences between the parameter \
estimates and the true parameter values."
}], "Notes",
 CellID->7711],

Cell[TextData[{
 Cell[BoxData["ParameterBias"], "InlineFormula"],
 " is based on the average curvature of the solution locus tangential to the \
least\[Hyphen]squares estimate."
}], "Notes",
 CellID->639957667]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10160],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["FitCurvatureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3665]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25995],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->17564]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParameterBias - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 15.4103584}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "ParameterBias is a possible value for the RegressionReport option for \
NonlinearRegress which represents the the estimated bias in the parameter \
estimates.", "synonyms" -> {}, "title" -> "ParameterBias", "type" -> "Symbol",
     "uri" -> "RegressionCommon/ref/ParameterBias"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1290, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1913, 62, 51, 1, 70, "ObjectName",
 CellID->32069],
Cell[1967, 65, 781, 22, 70, "Usage",
 CellID->4322]
}, Open  ]],
Cell[CellGroupData[{
Cell[2785, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3263, 109, 206, 5, 70, "Notes",
 CellID->7711],
Cell[3472, 116, 210, 5, 70, "Notes",
 CellID->639957667]
}, Closed]],
Cell[CellGroupData[{
Cell[3719, 126, 311, 9, 70, "SeeAlsoSection",
 CellID->10160],
Cell[4033, 137, 230, 6, 70, "SeeAlso",
 CellID->3665]
}, Open  ]],
Cell[CellGroupData[{
Cell[4300, 148, 314, 9, 70, "TutorialsSection",
 CellID->25995],
Cell[4617, 159, 182, 4, 70, "Tutorials",
 CellID->17564]
}, Open  ]],
Cell[4814, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

