(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7347,        244]
NotebookOptionsPosition[      5409,        186]
NotebookOutlinePosition[      6617,        217]
CellTagsIndexPosition[      6574,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ANOVATable" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/ANOVATable"], 
          "SequentialSumOfSquares" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/SequentialSumOfSquares"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ANOVATable\"\>", 
       2->"\<\"SequentialSumOfSquares\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PartialSumOfSquares", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PartialSumOfSquares"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " to ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula",
      ShowStringCharacters->False],
     " which represents the change in model sum of squares as nonconstant \
basis functions are removed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PartialSumOfSquares"], "InlineFormula"],
 " is useful for trimming a large set of predictors."
}], "Notes",
 CellID->5844],

Cell["\<\
Basis functions yielding a small value for partial sum of squares have less \
influence on the fit.\
\>", "Notes",
 CellID->116736900]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ANOVATable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ANOVATable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SequentialSumOfSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/SequentialSumOfSquares"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PartialSumOfSquares - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 22.5042900}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "PartialSumOfSquares is a possible value for the RegressionReport to \
Regress and DesignedRegress which represents the change in model sum of \
squares as nonconstant basis functions are removed.", "synonyms" -> {}, 
    "title" -> "PartialSumOfSquares", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/PartialSumOfSquares"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1436, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2059, 64, 62, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2124, 67, 1007, 29, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3168, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3646, 118, 153, 4, 70, "Notes",
 CellID->5844],
Cell[3802, 124, 144, 4, 70, "Notes",
 CellID->116736900]
}, Closed]],
Cell[CellGroupData[{
Cell[3983, 133, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[4302, 144, 521, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[4860, 166, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[5181, 177, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[5382, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

