(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10561,        367]
NotebookOptionsPosition[      7882,        280]
NotebookOutlinePosition[      9202,        317]
CellTagsIndexPosition[      9118,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AdjustedRSquared" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/AdjustedRSquared"], 
          "VarianceInflation" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/VarianceInflation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AdjustedRSquared\"\>", 
       2->"\<\"VarianceInflation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RSquared", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RSquared"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents the coefficient of determination ",
     Cell[BoxData[
      SuperscriptBox["R", "2"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["RSquared"], "InlineFormula"],
 " is the ratio of the model sum of squares to the total sum of squares."
}], "Notes",
 CellID->400245400],

Cell[TextData[{
 Cell[BoxData["RSquared"], "InlineFormula"],
 " gives the fraction of the variation of the response that is predicted by \
the model."
}], "Notes",
 CellID->676731005]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139763955],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->103569414],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["RSquared"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "RSquared", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->249755488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RSquared", "\[Rule]", "0.9810041805414752`"}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37821485]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AdjustedRSquared",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/AdjustedRSquared"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceInflation",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/VarianceInflation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RSquared - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 23.4105632}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "RSquared is a possible value for the RegressionReport option for Regress \
and DesignedRegress which represents the coefficient of determination R^2.", 
    "synonyms" -> {}, "title" -> "RSquared", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/RSquared"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4035, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->139763955]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8975, 305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1451, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2074, 65, 51, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2128, 68, 1002, 30, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3167, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3645, 120, 167, 4, 70, "Notes",
 CellID->400245400],
Cell[3815, 126, 183, 5, 70, "Notes",
 CellID->676731005]
}, Closed]],
Cell[CellGroupData[{
Cell[4035, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139763955],
Cell[CellGroupData[{
Cell[4420, 150, 148, 5, 70, "ExampleSection",
 CellID->103569414],
Cell[4571, 157, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4715, 163, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4768, 166, 937, 26, 70, "Input",
 CellID->26500],
Cell[5708, 194, 122, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[5855, 202, 301, 9, 70, "Input",
 CellID->249755488],
Cell[6159, 213, 234, 7, 36, "Output",
 CellID->37821485]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6454, 227, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6773, 238, 523, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7333, 260, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7654, 271, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[7855, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

