(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13466,        435]
NotebookOptionsPosition[     10650,        345]
NotebookOutlinePosition[     12046,        383]
CellTagsIndexPosition[     11961,        378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PredictedResponse" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/PredictedResponse"], 
          "MeanPredictionCITable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/MeanPredictionCITable"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PredictedResponse\"\>", 
       2->"\<\"MeanPredictionCITable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SinglePredictionCITable", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SinglePredictionCITable"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option which represents a table of confidence intervals for the \
predicted response of single observations."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SinglePredictionCITable"], "InlineFormula"],
 " includes the observed response value, the fitted response value, standard \
error and confidence interval for each data point."
}], "Notes",
 CellID->82101380],

Cell[TextData[{
 "The confidence level for the intervals can be specified via the ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->105005277],

Cell[TextData[{
 "In the regression report, ",
 Cell[BoxData["SinglePredictionCITable"], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " wrapper."
}], "Notes",
 CellID->438067598]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435067004],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->583590079],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["SinglePredictionCITable"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "SinglePredictionCITable", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SinglePredictionCITable", "\[Rule]", 
   TagBox[
    TagBox[GridBox[{
       {
        TagBox["\<\"Observed\"\>",
         HoldForm], 
        TagBox["\<\"Predicted\"\>",
         HoldForm], 
        TagBox["\<\"SE\"\>",
         HoldForm], 
        TagBox["\<\"CI\"\>",
         HoldForm]},
       {"90.`", "90.6010320530996`", "8.757774419303932`", 
        RowBox[{"{", 
         RowBox[{"70.40556802699945`", ",", "110.79649607919976`"}], "}"}]},
       {"95.`", "98.55965613968651`", "8.626085542514867`", 
        RowBox[{"{", 
         RowBox[{"78.66786720802234`", ",", "118.45144507135068`"}], "}"}]},
       {"110.`", "114.90325917464178`", "8.4065190140494`", 
        RowBox[{"{", 
         RowBox[{"95.5177915655714`", ",", "134.28872678371215`"}], "}"}]},
       {"125.`", "128.12025988986647`", "8.281961627007577`", 
        RowBox[{"{", 
         RowBox[{"109.02202213038476`", ",", "147.2184976493482`"}], "}"}]},
       {"140.`", "143.89538977577982`", "8.198591200648952`", 
        RowBox[{"{", 
         RowBox[{"124.98940456423483`", ",", "162.8013749873248`"}], "}"}]},
       {"150.`", "149.7222395534595`", "8.186211211079288`", 
        RowBox[{"{", 
         RowBox[{"130.84480264905594`", ",", "168.59967645786307`"}], "}"}]},
       {"175.`", "162.2286488323818`", "8.193512810548711`", 
        RowBox[{"{", 
         RowBox[{"143.33437440940816`", ",", "181.12292325535543`"}], "}"}]},
       {"190.`", "175.87200440938793`", "8.253948770708693`", 
        RowBox[{"{", 
         RowBox[{"156.8383644123703`", ",", "194.90564440640554`"}], "}"}]},
       {"210.`", "214.95453340602006`", "8.715667335826783`", 
        RowBox[{"{", 
         RowBox[{"194.8561684885396`", ",", "235.05289832350053`"}], "}"}]},
       {"255.`", "261.1429767656762`", "9.734252422307458`", 
        RowBox[{"{", 
         RowBox[{"238.69575042671403`", ",", "283.5902031046384`"}], "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     {None, OutputFormsDump`HeadedColumns}],
    Function[BoxForm`e$, 
     MatrixForm[
     BoxForm`e$, TableDepth -> 2, 
      TableHeadings -> {None, {"Observed", "Predicted", "SE", "CI"}}]]]}], 
  "}"}]], "Output",
 ImageSize->{514, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->81535924]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PredictedResponse",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanPredictionCITable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/MeanPredictionCITable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SinglePredictionCITable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 23.7543220}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "SinglePredictionCITable is a possible value for the RegressionReport \
option which represents a table of confidence intervals for the predicted \
response of single observations.", "synonyms" -> {}, "title" -> 
    "SinglePredictionCITable", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/SinglePredictionCITable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4161, 140, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->435067004]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11818, 371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1466, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2089, 65, 66, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2158, 68, 637, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2832, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3310, 107, 238, 5, 70, "Notes",
 CellID->82101380],
Cell[3551, 114, 283, 9, 70, "Notes",
 CellID->105005277],
Cell[3837, 125, 287, 10, 70, "Notes",
 CellID->438067598]
}, Closed]],
Cell[CellGroupData[{
Cell[4161, 140, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435067004],
Cell[CellGroupData[{
Cell[4546, 154, 148, 5, 70, "ExampleSection",
 CellID->583590079],
Cell[4697, 161, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4841, 167, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4894, 170, 937, 26, 70, "Input",
 CellID->26500],
Cell[5834, 198, 137, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[5996, 206, 315, 9, 70, "Input",
 CellID->26645265],
Cell[6314, 217, 2837, 68, 184, "Output",
 CellID->81535924]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9212, 292, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9531, 303, 533, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10101, 325, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10422, 336, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[10623, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

