(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16495,        546]
NotebookOptionsPosition[     13795,        458]
NotebookOutlinePosition[     15070,        494]
CellTagsIndexPosition[     14985,        489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RegressionReport" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/RegressionReport"], "Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
          "NonlinearRegress" :> 
          Documentation`HelpLookup[
           "paclet:NonlinearRegression/ref/NonlinearRegress"], 
          "DesignedRegress" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignedRegress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RegressionReport\"\>", 
       2->"\<\"Regress\"\>", 3->"\<\"NonlinearRegress\"\>", 
       4->"\<\"DesignedRegress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SummaryReport", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SummaryReport"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for regression functions."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For linear regression using ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 ", the summary includes ",
 Cell[BoxData[
  ButtonBox["ParameterTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterTable"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RSquared"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AdjustedRSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AdjustedRSquared"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11942],

Cell[TextData[{
 "For nonlinear regression using ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 ", the summary includes ",
 Cell[BoxData[
  ButtonBox["BestFitParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AsymptoticCorrelationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FitCurvatureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->249195656],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegressionReport",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"SummaryReport", ",", " ", 
     StyleBox["diagnostic", "TI"]}], "}"}]}]], "InlineFormula"],
 " will include the statistic ",
 Cell[BoxData[
  StyleBox["diagnostic", "TI"]], "InlineFormula"],
 " as well as the standard statistics specified by ",
 Cell[BoxData["SummaryReport"], "InlineFormula"],
 "."
}], "Notes",
 CellID->200539138]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198747262],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->141744727],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["SummaryReport"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "SummaryReport", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32626142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "87.04807487158759`", "4.115580148029904`", 
         "21.15086372774366`", "2.6234765249100178`*^-8"},
        {
         TagBox[
          SuperscriptBox["x", "2"],
          HoldForm], "1421.1828726048054`", "69.91953945393817`", 
         "20.325975881764165`", "3.587707775309923`*^-8"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x^2}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9810041805414752`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9786297031091596`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "60.88160136457192`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "25152.947189083425`", "25152.947189083425`", 
        "413.1452955460591`", "3.587707775309923`*^-8"},
       {"\<\"Error\"\>", "8", "487.05281091657537`", 
        "60.88160136457192`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "9", "25640.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 25152.9471890834, 25152.9471890834, 413.145295546059, 
        3.58770777530992*^-8}, {8, 487.052810916575, 60.8816013645719}, {
       9, 2564.}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 ImageSize->{530, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->270199384]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegressionReport",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReport"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonlinearRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignedRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignedRegress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SummaryReport - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 31.0513838}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "SummaryReport is a possible value for the RegressionReport option for \
regression functions.", "synonyms" -> {}, "title" -> "SummaryReport", "type" -> 
    "Symbol", "uri" -> "RegressionCommon/ref/SummaryReport"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6504, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->198747262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14842, 482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1728, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2351, 70, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2410, 73, 551, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2998, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3476, 111, 1176, 42, 70, "Notes",
 CellID->11942],
Cell[4655, 155, 1256, 44, 70, "Notes",
 CellID->249195656],
Cell[5914, 201, 553, 17, 70, "Notes",
 CellID->200539138]
}, Closed]],
Cell[CellGroupData[{
Cell[6504, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198747262],
Cell[CellGroupData[{
Cell[6889, 237, 148, 5, 70, "ExampleSection",
 CellID->141744727],
Cell[7040, 244, 141, 4, 70, "Input",
 CellID->455158924],
Cell[7184, 250, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[7237, 253, 937, 26, 70, "Input",
 CellID->26500],
Cell[8177, 281, 127, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[8329, 289, 305, 9, 70, "Input",
 CellID->32626142],
Cell[8637, 300, 3132, 80, 150, "Output",
 CellID->270199384]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11830, 387, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12149, 398, 1060, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13246, 438, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[13567, 449, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[13768, 456, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

