(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8630,        287]
NotebookOptionsPosition[      5989,        211]
NotebookOutlinePosition[      7337,        244]
CellTagsIndexPosition[      7294,        241]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Resonance Absorption Lines Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ElementAbsorptionMap",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/ElementAbsorptionMap"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the absorption map of an element"
}], "GuideText",
 CellID->403050860],

Cell[TextData[{
 Cell[TextData[ButtonBox["WavelengthAbsorptionMap",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/WavelengthAbsorptionMap"]],
   "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the absorption map in a given range of wavelengths"
}], "GuideText",
 CellID->265013090],

Cell["\t", "GuideDelimiter",
 CellID->9380603],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindIons",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/FindIons"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " resonance absorption lines in a wavelength range"
}], "GuideText",
 CellID->425818500],

Cell["\t", "GuideDelimiter",
 CellID->532225450],

Cell[TextData[{
 Cell[TextData[ButtonBox["IonStage",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/IonStage"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deuterium",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/Deuterium"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->478968717],

Cell["\t", "GuideDelimiter",
 CellID->109483852],

Cell[TextData[{
 Cell[TextData[ButtonBox["AtomicData",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " spectral data as a list of properties of an element"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892],

Cell[CellGroupData[{

Cell["Properties", "GuideFunctionsSubsection",
 CellID->39890884],

Cell[TextData[{
 Cell[TextData[ButtonBox["AirWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VacuumWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DampingConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OscillatorStrength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LowerStatisticalWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UpperStatisticalWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LowerTermFineStructureEnergy",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransitionProbability",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/TransitionProbability"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RelativeStrength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"]], \
"GuideTutorial",
 CellID->105287947]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/guide/UnitsPackage"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"],
  FontSlant->"Italic"],
 ButtonBox[" Data Collections",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]
}], "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resonance Absorption Lines Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 31.7545268}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Guide", "language" -> "en", "paclet" -> 
    "ResonanceAbsorptionLines Package", "status" -> "None", "summary" -> 
    "ElementAbsorptionMap -- plot the absorption map of an element, \
WavelengthAbsorptionMap -- plot the absorption map in a given range of \
wavelengths, FindIons -- resonance absorption lines in a wavelength range, \
AtomicData -- spectral data as a list of properties of an element", 
    "synonyms" -> {}, "title" -> "Resonance Absorption Lines Package", "type" -> 
    "Guide", "uri" -> 
    "ResonanceAbsorptionLines/guide/ResonanceAbsorptionLinesPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 76, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[698, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[757, 31, 313, 9, 70, "GuideText",
 CellID->403050860],
Cell[1073, 42, 337, 9, 70, "GuideText",
 CellID->265013090],
Cell[1413, 53, 46, 1, 70, "GuideDelimiter",
 CellID->9380603],
Cell[1462, 56, 300, 9, 70, "GuideText",
 CellID->425818500],
Cell[1765, 67, 48, 1, 70, "GuideDelimiter",
 CellID->532225450],
Cell[1816, 70, 454, 13, 70, "InlineGuideFunctionListing",
 CellID->478968717],
Cell[2273, 85, 48, 1, 70, "GuideDelimiter",
 CellID->109483852],
Cell[2324, 88, 307, 9, 70, "GuideText",
 CellID->203374175],
Cell[2634, 99, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892],
Cell[CellGroupData[{
Cell[2717, 104, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->39890884],
Cell[2785, 107, 2305, 63, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5139, 176, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5204, 179, 207, 5, 70, "GuideTutorial",
 CellID->105287947]
}, Open  ]],
Cell[CellGroupData[{
Cell[5448, 189, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5513, 192, 148, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5664, 197, 283, 9, 70, "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],
Cell[5962, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

