(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9999,        322]
NotebookOptionsPosition[      7958,        260]
NotebookOutlinePosition[      9181,        291]
CellTagsIndexPosition[      9138,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["RESONANCE ABSORPTION LINES PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Resonance Absorption Lines Package" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/tutorial/\
ResonanceAbsorptionLines"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Resonance Absorption Lines Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IonStage" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/IonStage"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IonStage\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AtomicData", "ObjectName",
 CellID->27606],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AtomicData", "[", 
       StyleBox["element", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the spectral data of the resonance absorption \
lines produced by element ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AtomicData", "[", 
       RowBox[{
        StyleBox["element", "TI"], ",", 
        StyleBox["ionstage", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the data for the lines of the ionization level ",
     
     Cell[BoxData[
      StyleBox["ionstage", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24795]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AtomicData", "[", 
   StyleBox["element", "TI"], "]"}]], "InlineFormula"],
 " gives a list of properties for the lines produced by the specified \
element."
}], "Notes",
 CellID->29171],

Cell["These properties are:", "Notes",
 CellID->3621],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["VacuumWavelength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "vacuum wavelength", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["AirWavelength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"], "[", 
     StyleBox["element", "TI"], "]"}], Cell["air wavelength", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["LowerTermFineStructureEnergy",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "lower term fine structure energy", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["LowerStatisticalWeight",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "statistical weight of the lower level", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["UpperStatisticalWeight",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "statistical weight of the upper level", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["RelativeStrength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "relative strength", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["TransitionProbability",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/TransitionProbability"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "transition probability", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["DampingConstant",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"], "[",
      
     StyleBox["element", "TI"], "]"}], Cell[
    "damping constant", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["OscillatorStrength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "oscillator strength of the element", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->523898633],

Cell["\<\
Individual properties can be selected using related functions.\
\>", "Notes",
 CellID->7675]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17786],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["IonStage",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/IonStage"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8373]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18725],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"]], \
"Tutorials",
 CellID->22807]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AtomicData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 38.4890742}", "context" -> 
    "ResonanceAbsorptionLines`", "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Symbol", "language" -> "en", "paclet" -> 
    "ResonanceAbsorptionLines Package", "status" -> "None", "summary" -> 
    "AtomicData[element] gives the spectral data of the resonance absorption \
lines produced by element element. AtomicData[element, ionstage] gives the \
data for the lines of the ionization level ionstage. ", "synonyms" -> {}, 
    "title" -> "AtomicData", "type" -> "Symbol", "uri" -> 
    "ResonanceAbsorptionLines/ref/AtomicData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1287, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1910, 62, 48, 1, 70, "ObjectName",
 CellID->27606],
Cell[1961, 65, 904, 28, 70, "Usage",
 CellID->24795]
}, Open  ]],
Cell[CellGroupData[{
Cell[2902, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3380, 115, 227, 7, 70, "Notes",
 CellID->29171],
Cell[3610, 124, 53, 1, 70, "Notes",
 CellID->3621],
Cell[3666, 127, 3021, 80, 70, "2ColumnTableMod",
 CellID->523898633],
Cell[6690, 209, 102, 3, 70, "Notes",
 CellID->7675]
}, Closed]],
Cell[CellGroupData[{
Cell[6829, 217, 311, 9, 70, "SeeAlsoSection",
 CellID->17786],
Cell[7143, 228, 220, 6, 70, "SeeAlso",
 CellID->8373]
}, Open  ]],
Cell[CellGroupData[{
Cell[7400, 239, 314, 9, 70, "TutorialsSection",
 CellID->18725],
Cell[7717, 250, 199, 5, 70, "Tutorials",
 CellID->22807]
}, Open  ]],
Cell[7931, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

