(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7267,        233]
NotebookOptionsPosition[      5439,        182]
NotebookOutlinePosition[      6811,        215]
CellTagsIndexPosition[      6768,        212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["RESONANCE ABSORPTION LINES PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Resonance Absorption Lines Package" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/tutorial/\
ResonanceAbsorptionLines"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Resonance Absorption Lines Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VacuumWavelength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], 
          "IonStage" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/IonStage"], "AtomicData" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/AtomicData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VacuumWavelength\"\>", 
       2->"\<\"IonStage\"\>", 3->"\<\"AtomicData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DampingConstant", "ObjectName",
 CellID->6509],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DampingConstant", "[", 
       StyleBox["element", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["wavelength", "TI"], 
         StyleBox["v", "TI"]], ",", 
        StyleBox["damping", "TI"]}], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     " is the wavelength in vacuum and ",
     Cell[BoxData[
      StyleBox["damping", "TI"]], "InlineFormula"],
     " is the natural damping constant of the resonance absorption lines \
produced by element ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DampingConstant", "[", 
       RowBox[{
        StyleBox["element", "TI"], ",", 
        StyleBox["ionstage", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of pairs for the lines of the ionization \
level ",
     Cell[BoxData[
      StyleBox["ionstage", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26368],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VacuumWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IonStage",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/IonStage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtomicData",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12578],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"]], \
"Tutorials",
 CellID->30959]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DampingConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 38.6765790}", "context" -> 
    "ResonanceAbsorptionLines`", "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Symbol", "language" -> "en", "paclet" -> 
    "ResonanceAbsorptionLines Package", "status" -> "None", "summary" -> 
    "DampingConstant[element] gives a list of {wavelength_v, damping} pairs, \
where wavelength_v is the wavelength in vacuum and damping is the natural \
damping constant of the resonance absorption lines produced by element \
element. DampingConstant[element, ionstage] gives a list of pairs for the \
lines of the ionization level ionstage.", "synonyms" -> {}, "title" -> 
    "DampingConstant", "type" -> "Symbol", "uri" -> 
    "ResonanceAbsorptionLines/ref/DampingConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1596, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2219, 67, 52, 1, 70, "ObjectName",
 CellID->6509],
Cell[2274, 70, 1428, 44, 70, "Usage",
 CellID->15822]
}, Open  ]],
Cell[CellGroupData[{
Cell[3739, 119, 311, 9, 70, "SeeAlsoSection",
 CellID->26368],
Cell[4053, 130, 791, 26, 70, "SeeAlso",
 CellID->31041]
}, Open  ]],
Cell[CellGroupData[{
Cell[4881, 161, 314, 9, 70, "TutorialsSection",
 CellID->12578],
Cell[5198, 172, 199, 5, 70, "Tutorials",
 CellID->30959]
}, Open  ]],
Cell[5412, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

