(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9956,        316]
NotebookOptionsPosition[      8215,        262]
NotebookOutlinePosition[      9310,        291]
CellTagsIndexPosition[      9267,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["RESONANCE ABSORPTION LINES PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Resonance Absorption Lines Package" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/tutorial/\
ResonanceAbsorptionLines"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Resonance Absorption Lines Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VacuumWavelength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], 
          "AirWavelength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/AirWavelength"], 
          "LowerTermFineStructureEnergy" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"]\
, "LowerStatisticalWeight" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"], 
          "UpperStatisticalWeight" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"], 
          "RelativeStrength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/RelativeStrength"], 
          "TransitionProbability" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/TransitionProbability"], 
          "DampingConstant" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/DampingConstant"], 
          "OscillatorStrength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"VacuumWavelength\"\>", 
       2->"\<\"AirWavelength\"\>", 3->"\<\"LowerTermFineStructureEnergy\"\>", 
       4->"\<\"LowerStatisticalWeight\"\>", 
       5->"\<\"UpperStatisticalWeight\"\>", 6->"\<\"RelativeStrength\"\>", 
       7->"\<\"TransitionProbability\"\>", 8->"\<\"DampingConstant\"\>", 
       9->"\<\"OscillatorStrength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IonStage", "ObjectName",
 CellID->23973],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IonStage"], "InlineFormula"],
     " \[LineSeparator]is the ionization level of the element producing \
resonance absorption lines."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["IonStage"], "InlineFormula"],
 " is used in the data returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AtomicData",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"], "[", 
   StyleBox["element", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2855]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6150],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VacuumWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AirWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerTermFineStructureEnergy",
    BaseStyle->"Link",
    ButtonData->
     "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerStatisticalWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"],
   
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpperStatisticalWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"],
   
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RelativeStrength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransitionProbability",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/TransitionProbability"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DampingConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OscillatorStrength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31486]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30127],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"]], \
"Tutorials",
 CellID->10797]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IonStage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 39.3015950}", "context" -> 
    "ResonanceAbsorptionLines`", "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Symbol", "language" -> "en", "paclet" -> 
    "ResonanceAbsorptionLines Package", "status" -> "None", "summary" -> 
    "IonStage is the ionization level of the element producing resonance \
absorption lines.", "synonyms" -> {}, "title" -> "IonStage", "type" -> 
    "Symbol", "uri" -> "ResonanceAbsorptionLines/ref/IonStage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2768, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3391, 90, 46, 1, 70, "ObjectName",
 CellID->23973],
Cell[3440, 93, 376, 11, 70, "Usage",
 CellID->14979]
}, Open  ]],
Cell[CellGroupData[{
Cell[3853, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4331, 126, 336, 11, 70, "Notes",
 CellID->2855]
}, Closed]],
Cell[CellGroupData[{
Cell[4704, 142, 310, 9, 70, "SeeAlsoSection",
 CellID->6150],
Cell[5017, 153, 2603, 83, 70, "SeeAlso",
 CellID->31486]
}, Open  ]],
Cell[CellGroupData[{
Cell[7657, 241, 314, 9, 70, "TutorialsSection",
 CellID->30127],
Cell[7974, 252, 199, 5, 70, "Tutorials",
 CellID->10797]
}, Open  ]],
Cell[8188, 260, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

