(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7330,        233]
NotebookOptionsPosition[      5465,        182]
NotebookOutlinePosition[      6875,        215]
CellTagsIndexPosition[      6832,        212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["RESONANCE ABSORPTION LINES PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Resonance Absorption Lines Package" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/tutorial/\
ResonanceAbsorptionLines"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Resonance Absorption Lines Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VacuumWavelength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], 
          "IonStage" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/IonStage"], "AtomicData" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/AtomicData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VacuumWavelength\"\>", 
       2->"\<\"IonStage\"\>", 3->"\<\"AtomicData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TransitionProbability", "ObjectName",
 CellID->7526],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TransitionProbability", "[", 
       StyleBox["element", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["wavelength", "TI"], 
         StyleBox["v", "TI"]], ",", 
        StyleBox["prob", "TI"]}], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     " is the wavelength in vacuum and ",
     Cell[BoxData[
      StyleBox["prob", "TI"]], "InlineFormula"],
     " is the spontaneous transition probability of the resonance absorption \
lines produced by the element  ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TransitionProbability", "[", 
       RowBox[{
        StyleBox["element", "TI"], ",", 
        StyleBox["ionstage", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of pairs for the lines of the ionization \
level ",
     Cell[BoxData[
      StyleBox["ionstage", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14268]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21700],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VacuumWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IonStage",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/IonStage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtomicData",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7917],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"]], \
"Tutorials",
 CellID->21870]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransitionProbability - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 46.6767838}", "context" -> 
    "ResonanceAbsorptionLines`", "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Symbol", "language" -> "en", "paclet" -> 
    "ResonanceAbsorptionLines Package", "status" -> "None", "summary" -> 
    "TransitionProbability[element] gives a list of {wavelength_v, prob} \
pairs, where wavelength_v is the wavelength in vacuum and prob is the \
spontaneous transition probability of the resonance absorption lines produced \
by the element element. TransitionProbability[element, ionstage] gives a list \
of pairs for the lines of the ionization level ionstage.", "synonyms" -> {}, 
    "title" -> "TransitionProbability", "type" -> "Symbol", "uri" -> 
    "ResonanceAbsorptionLines/ref/TransitionProbability"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1596, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2219, 67, 58, 1, 70, "ObjectName",
 CellID->7526],
Cell[2280, 70, 1449, 44, 70, "Usage",
 CellID->14268]
}, Open  ]],
Cell[CellGroupData[{
Cell[3766, 119, 311, 9, 70, "SeeAlsoSection",
 CellID->21700],
Cell[4080, 130, 791, 26, 70, "SeeAlso",
 CellID->22022]
}, Open  ]],
Cell[CellGroupData[{
Cell[4908, 161, 313, 9, 70, "TutorialsSection",
 CellID->7917],
Cell[5224, 172, 199, 5, 70, "Tutorials",
 CellID->21870]
}, Open  ]],
Cell[5438, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

