(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10998,        334]
NotebookOptionsPosition[      9246,        284]
NotebookOutlinePosition[     10540,        316]
CellTagsIndexPosition[     10497,        313]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["RESONANCE ABSORPTION LINES PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Resonance Absorption Lines Package" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/tutorial/\
ResonanceAbsorptionLines"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Resonance Absorption Lines Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IonStage" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/IonStage"], "AtomicData" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/AtomicData"], 
          "WavelengthAbsorptionMap" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/WavelengthAbsorptionMap"], 
          "AirWavelength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/AirWavelength"], "FindIons" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/FindIons"], 
          "OscillatorStrength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"], 
          "RelativeStrength" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/RelativeStrength"], 
          "TransitionProbability" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/TransitionProbability"], 
          "LowerStatisticalWeight" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"], 
          "UpperStatisticalWeight" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"], 
          "LowerTermFineStructureEnergy" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"]\
, "DampingConstant" :> 
          Documentation`HelpLookup[
           "paclet:ResonanceAbsorptionLines/ref/DampingConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IonStage\"\>", 
       2->"\<\"AtomicData\"\>", 3->"\<\"WavelengthAbsorptionMap\"\>", 
       4->"\<\"AirWavelength\"\>", 5->"\<\"FindIons\"\>", 
       6->"\<\"OscillatorStrength\"\>", 7->"\<\"RelativeStrength\"\>", 
       8->"\<\"TransitionProbability\"\>", 
       9->"\<\"LowerStatisticalWeight\"\>", 
       10->"\<\"UpperStatisticalWeight\"\>", 
       11->"\<\"LowerTermFineStructureEnergy\"\>", 
       12->"\<\"DampingConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VacuumWavelength", "ObjectName",
 CellID->872],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VacuumWavelength", "[", 
       StyleBox["element", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the wavelengths in vacuum of the \
resonance absorption lines produced by the specified ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VacuumWavelength", "[", 
       RowBox[{
        StyleBox["element", "TI"], ",", 
        StyleBox["ionstage", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the wavelength in vacuum for the lines of the \
ionization level ",
     Cell[BoxData[
      StyleBox["ionstage", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18443],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IonStage",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/IonStage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtomicData",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WavelengthAbsorptionMap",
    BaseStyle->"Link",
    ButtonData->
     "paclet:ResonanceAbsorptionLines/ref/WavelengthAbsorptionMap"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AirWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindIons",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/FindIons"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OscillatorStrength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RelativeStrength",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransitionProbability",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/TransitionProbability"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerStatisticalWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"],
   
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpperStatisticalWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"],
   
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerTermFineStructureEnergy",
    BaseStyle->"Link",
    ButtonData->
     "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DampingConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20676]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22189],

Cell[TextData[ButtonBox["Resonance Absorption Lines Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"]], \
"Tutorials",
 CellID->27866]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VacuumWavelength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 47.0205426}", "context" -> 
    "ResonanceAbsorptionLines`", "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Symbol", "language" -> "en", "paclet" -> 
    "ResonanceAbsorptionLines Package", "status" -> "None", "summary" -> 
    "VacuumWavelength[element] gives a list of the wavelengths in vacuum of \
the resonance absorption lines produced by the specified element. \
VacuumWavelength[element, ionstage] gives the wavelength in vacuum for the \
lines of the ionization level ionstage.", "synonyms" -> {}, "title" -> 
    "VacuumWavelength", "type" -> "Symbol", "uri" -> 
    "ResonanceAbsorptionLines/ref/VacuumWavelength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3234, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3857, 100, 52, 1, 70, "ObjectName",
 CellID->872],
Cell[3912, 103, 951, 28, 70, "Usage",
 CellID->25652]
}, Open  ]],
Cell[CellGroupData[{
Cell[4900, 136, 311, 9, 70, "SeeAlsoSection",
 CellID->18443],
Cell[5214, 147, 3437, 111, 70, "SeeAlso",
 CellID->20676]
}, Open  ]],
Cell[CellGroupData[{
Cell[8688, 263, 314, 9, 70, "TutorialsSection",
 CellID->22189],
Cell[9005, 274, 199, 5, 70, "Tutorials",
 CellID->27866]
}, Open  ]],
Cell[9219, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

