(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10550,        344]
NotebookOptionsPosition[      8283,        268]
NotebookOutlinePosition[      9488,        304]
CellTagsIndexPosition[      9404,        299]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], "SplineFit" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineFit"], "Bezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Bezier"], 
         "CompositeBezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/CompositeBezier"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"SplineFit\"\>", 3->"\<\"Bezier\"\>", 
      4->"\<\"CompositeBezier\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cubic", "ObjectName",
 CellID->14545],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cubic"], "InlineFormula"],
     " \[LineSeparator]is a setting specifying the type of spline generated \
by ",
     Cell[BoxData[
      ButtonBox["Spline",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/Spline"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["SplineFit",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/SplineFit"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A cubic spline is made of piecewise third\[Hyphen]order polynomials, with \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["C", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 " continuity, and interpolates each of the points it is created from."
}], "Notes",
 CellID->20727],

Cell[TextData[{
 "The second derivative of the spline at the endpoints is set to ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "Notes",
 CellID->18250]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->740210307],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->695955683],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->355594487],

Cell["Cubic splines go through all of the points:", "ExampleText",
 CellID->515573858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Cubic"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1832633730],

Cell[BoxData[
 GraphicsBox[{
   LineBox[{{0, 0}, {0.100390625, -0.090234375}, {0.203125, -0.171875}, {
     0.256103515625, -0.206787109375}, {0.310546875, -0.236328125}, {
     0.366748046875, -0.259423828125}, {
     0.395599365234375, -0.268218994140625}, {0.425, -0.275}, {
     0.485595703125, -0.281982421875}, {
     0.516864013671875, -0.281915283203125}, {0.548828125, -0.279296875}, {
     0.614990234375, -0.265869140625}, {
     0.649261474609375, -0.254791259765625}, {0.684375, -0.240625}, {
     0.757275390625, -0.202490234375}, {0.833984375, -0.150390625}, {1, 0}, {
     1.182421875, 0.214453125}, {1.371875, 0.478125}, {1.556640625, 
     0.771484375}, {1.725, 1.075}, {1.865234375, 1.369140625}, {1.965625, 
     1.634375}, {1.997216796875, 1.750048828125}, {2.014453125, 
     1.851171875}, {2.01723022460937, 1.89551391601562}, {2.015869140625, 
     1.935302734375}, {2.01018676757813, 1.97023315429687}, {2.00566787719727,
      1.98578109741211}, {2.00297899246216, 1.99305906295776}, {2, 2}, {
     1.99316711425781, 2.01286163330078}, {1.9851806640625, 
     2.02437744140625}, {1.97605895996094, 2.03456878662109}, {
     1.97107810974121, 2.03917446136475}, {1.9658203125, 2.04345703125}, {
     1.95448303222656, 2.05106353759766}, {1.9420654296875, 
     2.05740966796875}, {1.92858581542969, 2.06251678466797}, {
     1.92145347595215, 2.06461238861084}, {1.91779017448425, 
     2.06554687023163}, {1.9140625, 2.06640625}, {1.8819580078125, 
     2.07061767578125}, {1.8458984375, 2.07021484375}, {1.8060302734375, 
     2.06536865234375}, {1.7625, 2.05625}, {1.6650390625, 2.02587890625}, {
     1.5546875, 1.98046875}, {1.3, 1.85}, {1.0078125, 1.67578125}, {0.6875, 
     1.46875}, {0.3484375, 1.23984375}, {0, 1}}], 
   PointBox[{{0, 0}, {1, 0}, {2, 2}, {0, 1}}]}]], "Output",
 ImageSize->{184, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1945102374]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17730],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineFit",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Bezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompositeBezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/CompositeBezier"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8396]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cubic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 54.6769886}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "Cubic is a setting specifying the type of spline generated by Spline and \
SplineFit.", "synonyms" -> {}, "title" -> "Cubic", "type" -> "Symbol", "uri" -> 
    "Splines/ref/Cubic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3259, 114, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->740210307]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9261, 292}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 910, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1533, 47, 43, 1, 70, "ObjectName",
 CellID->14545],
Cell[1579, 50, 660, 21, 70, "Usage",
 CellID->5540]
}, Open  ]],
Cell[CellGroupData[{
Cell[2276, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2754, 93, 310, 9, 70, "Notes",
 CellID->20727],
Cell[3067, 104, 155, 5, 70, "Notes",
 CellID->18250]
}, Closed]],
Cell[CellGroupData[{
Cell[3259, 114, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->740210307],
Cell[CellGroupData[{
Cell[3644, 128, 148, 5, 70, "ExampleSection",
 CellID->695955683],
Cell[3795, 135, 130, 3, 70, "Input",
 CellID->355594487],
Cell[3928, 140, 86, 1, 70, "ExampleText",
 CellID->515573858],
Cell[CellGroupData[{
Cell[4039, 145, 899, 30, 47, "Input",
 CellID->1832633730],
Cell[4941, 177, 1945, 33, 229, "Output",
 CellID->1945102374]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6947, 217, 311, 9, 70, "SeeAlsoSection",
 CellID->17730],
Cell[7261, 228, 980, 35, 70, "SeeAlso",
 CellID->8396]
}, Open  ]],
Cell[8256, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

