(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9475,        291]
NotebookOptionsPosition[      7380,        223]
NotebookOutlinePosition[      8668,        260]
CellTagsIndexPosition[      8584,        255]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], 
         "SplinePoints" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplinePoints"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"SplinePoints\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SplineDivision", "ObjectName",
 CellID->17779],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SplineDivision"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Spline",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/Spline"]], "InlineFormula"],
     " which specifies the maximum number of subdivisions to be used in \
attempting to generate a smooth spline."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15832]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->29846336],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->48883559],

Cell[TextData[{
 "Higher values for ",
 Cell[BoxData["SplineDivision"], "InlineFormula"],
 " results in smoother curves:"
}], "ExampleText",
 CellID->176016915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier", ",", 
      " ", 
      RowBox[{"SplinePoints", "\[Rule]", "8"}], ",", " ", 
      RowBox[{"SplineDivision", "\[Rule]", "#"}]}], "]"}], "]"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->769257030],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    LineBox[{{0., 0.}, {0.419825072886297, 0.107871720116618}, {
     0.787172011661808, 0.373177842565598}, {1.04956268221574, 
     0.708454810495627}, {1.15451895043732, 1.02623906705539}, {
     1.04956268221574, 1.23906705539359}, {0.682215743440234, 
     1.25947521865889}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.213192419825073, 0.0287900874635568}, {
     0.419825072886297, 0.107871720116618}, {0.613338192419825, 
     0.22631195335277}, {0.787172011661808, 0.373177842565598}, {
     0.934766763848397, 0.537536443148688}, {1.04956268221574, 
     0.708454810495627}, {1.125, 0.875}, {1.15451895043732, 
     1.02623906705539}, {1.13155976676385, 1.15123906705539}, {
     1.04956268221574, 1.23906705539359}, {0.901967930029155, 
     1.27879008746356}, {0.682215743440234, 1.25947521865889}, {0., 1.}}]], 
   ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.107006195335277, 0.0074252915451895}, {
     0.213192419825073, 0.0287900874635568}, {0.317738702623907, 
     0.0627277696793003}, {0.419825072886297, 0.107871720116618}, {
     0.613338192419825, 0.22631195335277}, {0.703125, 0.296875}, {
     0.787172011661808, 0.373177842565598}, {0.934766763848397, 
     0.537536443148688}, {0.996674562682216, 0.622858965014577}, {
     1.04956268221574, 0.708454810495627}, {1.0926111516035, 
     0.792957361516035}, {1.125, 0.875}, {1.14590925655977, 
     0.95321610787172}, {1.15451895043732, 1.02623906705539}, {
     1.15000911078717, 1.09270225947522}, {1.13155976676385, 
     1.15123906705539}, {1.09835094752187, 1.20048287172012}, {
     1.04956268221574, 1.23906705539359}, {0.984375, 1.265625}, {
     0.901967930029155, 1.27879008746356}, {0.801521501457726, 
     1.27719569970846}, {0.682215743440234, 1.25947521865889}, {0., 1.}}]], 
   ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.107006195335277, 0.0074252915451895}, {
     0.213192419825073, 0.0287900874635568}, {0.317738702623907, 
     0.0627277696793003}, {0.419825072886297, 0.107871720116618}, {
     0.613338192419825, 0.22631195335277}, {0.703125, 0.296875}, {
     0.787172011661808, 0.373177842565598}, {0.934766763848397, 
     0.537536443148688}, {0.996674562682216, 0.622858965014577}, {
     1.04956268221574, 0.708454810495627}, {1.0926111516035, 
     0.792957361516035}, {1.125, 0.875}, {1.14590925655977, 
     0.95321610787172}, {1.15451895043732, 1.02623906705539}, {
     1.15000911078717, 1.09270225947522}, {1.13155976676385, 
     1.15123906705539}, {1.09835094752187, 1.20048287172012}, {
     1.04956268221574, 1.23906705539359}, {0.984375, 1.265625}, {
     0.901967930029155, 1.27879008746356}, {0.801521501457726, 
     1.27719569970846}, {0.682215743440234, 1.25947521865889}, {0., 1.}}]]}], 
  "}"}]], "Output",
 ImageSize->{390, 414},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1654315696]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12485],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplinePoints",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplinePoints"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8324]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SplineDivision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 55.0051220}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "SplineDivision is an option for Spline which specifies the maximum \
number of subdivisions to be used in attempting to generate a smooth spline.",
     "synonyms" -> {}, "title" -> "SplineDivision", "type" -> "Symbol", "uri" -> 
    "Splines/ref/SplineDivision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1980, 68, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8450, 248}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 689, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1312, 44, 52, 1, 70, "ObjectName",
 CellID->17779],
Cell[1367, 47, 576, 16, 70, "Usage",
 CellID->15832]
}, Open  ]],
Cell[CellGroupData[{
Cell[1980, 68, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2357, 82, 147, 5, 70, "ExampleSection",
 CellID->29846336],
Cell[2507, 89, 129, 3, 70, "Input",
 CellID->48883559],
Cell[2639, 94, 160, 5, 70, "ExampleText",
 CellID->176016915],
Cell[CellGroupData[{
Cell[2824, 103, 726, 23, 47, "Input",
 CellID->769257030],
Cell[3553, 128, 2940, 55, 435, "Output",
 CellID->1654315696]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6554, 190, 311, 9, 70, "SeeAlsoSection",
 CellID->12485],
Cell[6868, 201, 470, 17, 70, "SeeAlso",
 CellID->8324]
}, Open  ]],
Cell[7353, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

