(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9933,        320]
NotebookOptionsPosition[      7673,        245]
NotebookOutlinePosition[      8928,        282]
CellTagsIndexPosition[      8844,        277]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], 
         "SplineDivision" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineDivision"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"SplineDivision\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SplinePoints", "ObjectName",
 CellID->387],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SplinePoints"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Spline",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/Spline"]], "InlineFormula"],
     " which determines the number of initial samples for rendering a spline. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData["SplinePoints"], "InlineFormula"],
 " is ",
 Cell[BoxData["25"], "InlineFormula"],
 "."
}], "Notes",
 CellID->25529]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209467374],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->416919897],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->41371707],

Cell[TextData[{
 "Higher values for ",
 Cell[BoxData["SplinePoints"], "InlineFormula"],
 " results in smoother curves:"
}], "ExampleText",
 CellID->176016915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier", ",", 
      " ", 
      RowBox[{"SplinePoints", "\[Rule]", "#"}], ",", " ", 
      RowBox[{"SplineDivision", "\[Rule]", "0"}]}], "]"}], "]"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"4", ",", "8", ",", " ", "16", ",", " ", "32"}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->769257030],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    LineBox[{{0., 0.}, {0.888888888888889, 0.481481481481482}, {
     1.11111111111111, 1.18518518518519}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.419825072886297, 0.107871720116618}, {
     0.787172011661808, 0.373177842565598}, {1.04956268221574, 
     0.708454810495627}, {1.15451895043732, 1.02623906705539}, {
     1.04956268221574, 1.23906705539359}, {0.682215743440234, 
     1.25947521865889}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.199111111111111, 0.0251851851851852}, {
     0.392888888888889, 0.0948148148148148}, {0.576, 0.2}, {0.743111111111111,
      0.331851851851852}, {0.888888888888889, 0.481481481481482}, {1.008, 
     0.64}, {1.09511111111111, 0.798518518518519}, {1.14488888888889, 
     0.948148148148148}, {1.152, 1.08}, {1.11111111111111, 
     1.18518518518519}, {1.01688888888889, 1.25481481481481}, {0.864, 1.28}, {
     0.647111111111111, 1.25185185185185}, {0.360888888888889, 
     1.16148148148148}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.0966734919942265, 0.00607566043435937}, {
     0.192742774663489, 0.0236312980430331}, {0.287603638682824, 
     0.0516598972844147}, {0.380651874727267, 0.0891544426168977}, {
     0.471283273471854, 0.135107918498875}, {0.558893625591621, 
     0.188513309388742}, {0.642878721761606, 0.248363599744889}, {
     0.722634352656843, 0.313651774025712}, {0.797556308952368, 
     0.383370816689604}, {0.867040381323219, 0.456513712194958}, {
     0.93048236044443, 0.532073445000168}, {0.987278036991038, 
     0.609042999563627}, {1.03682320163808, 0.686415360343728}, {
     1.07851364506059, 0.763183511798865}, {1.1117451579336, 
     0.838340438387433}, {1.13591353093216, 0.910879124567823}, {
     1.15041455473129, 0.979792554798429}, {1.15464402000604, 
     1.04407371353765}, {1.14799771743144, 1.10271558524387}, {
     1.12987143768252, 1.15471115437548}, {1.09966097143433, 
     1.19905340539089}, {1.05676210936189, 1.23473532274848}, {
     1.00057064214024, 1.26074989090665}, {0.93048236044443, 
     1.27609009432379}, {0.845893054949482, 1.27974891745829}, {
     0.746198516330436, 1.27071934476855}, {0.630794535262328, 
     1.24799436071297}, {0.499076902420195, 1.21056694974992}, {
     0.350441408479072, 1.15743009633782}, {0.184283844113994, 
     1.08757678493505}, {0., 1.}}]]}], "}"}]], "Output",
 ImageSize->{390, 412},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472643424]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21527],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineDivision",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineDivision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19385]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SplinePoints - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 56.4582842}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "SplinePoints is an option for Spline which determines the number of \
initial samples for rendering a spline. ", "synonyms" -> {}, "title" -> 
    "SplinePoints", "type" -> "Symbol", "uri" -> 
    "Splines/ref/SplinePoints"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2634, 97, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->209467374]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8702, 270}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 695, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1318, 44, 48, 1, 70, "ObjectName",
 CellID->387],
Cell[1369, 47, 541, 16, 70, "Usage",
 CellID->27845]
}, Open  ]],
Cell[CellGroupData[{
Cell[1947, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2425, 85, 172, 7, 70, "Notes",
 CellID->25529]
}, Closed]],
Cell[CellGroupData[{
Cell[2634, 97, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209467374],
Cell[CellGroupData[{
Cell[3019, 111, 148, 5, 70, "ExampleSection",
 CellID->416919897],
Cell[3170, 118, 129, 3, 70, "Input",
 CellID->41371707],
Cell[3302, 123, 158, 5, 70, "ExampleText",
 CellID->176016915],
Cell[CellGroupData[{
Cell[3485, 132, 740, 24, 47, "Input",
 CellID->769257030],
Cell[4228, 158, 2553, 47, 433, "Output",
 CellID->472643424]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6842, 212, 311, 9, 70, "SeeAlsoSection",
 CellID->21527],
Cell[7156, 223, 475, 17, 70, "SeeAlso",
 CellID->19385]
}, Open  ]],
Cell[7646, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

