(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8553,        263]
NotebookOptionsPosition[      6812,        210]
NotebookOutlinePosition[      7937,        240]
CellTagsIndexPosition[      7894,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Standard Atmosphere Package" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Standard Atmosphere Package\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AtmosphericPlot", "ObjectName",
 CellID->23296],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AtmosphericPlot", "[", 
       StyleBox["property", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the specified property ",
     Cell[BoxData[
      StyleBox["property", "TI"]], "InlineFormula"],
     " as a function of geometric altitude. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AtmosphericPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->397263883],

Cell[TextData[{
 "Possible values for ",
 Cell[BoxData[
  StyleBox["property", "TI"]], "InlineFormula"],
 " are:"
}], "Notes",
 CellID->27873],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CollisionFrequency",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/CollisionFrequency"], Cell[
    "collision frequency", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DynamicViscosity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/DynamicViscosity"], Cell[
    "coefficient of dynamic viscosity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["GravityAcceleration",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/GravityAcceleration"], Cell[
    "45 degree latitude acceleration of gravity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["KinematicViscosity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/KinematicViscosity"], Cell[
    "kinematic viscosity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["KineticTemperature",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/KineticTemperature"], Cell[
    "kinematic temperature", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeanDensity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanDensity"], Cell[
    "mean density of air", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeanFreePath",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanFreePath"], Cell[
    "mean free path", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeanMolecularWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanMolecularWeight"], Cell[
    "mean molecular weight", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeanParticleSpeed",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanParticleSpeed"], Cell[
    "mean particle speed", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberDensity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/NumberDensity"], Cell[
    "total number density", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Pressure",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/Pressure"], Cell[
    "total atmospheric pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PressureScaleHeight",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/PressureScaleHeight"], Cell[
    "local pressure scale height", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SoundSpeed",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/SoundSpeed"], Cell[
    "speed of sound", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ThermalConductivityCoefficient",
     BaseStyle->"Link",
     ButtonData->
      "paclet:StandardAtmosphere/ref/ThermalConductivityCoefficient"], Cell[
    "coefficient of thermal conductivity", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->177078669]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24716],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "Tutorials",
 CellID->9562]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AtmosphericPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 2.6459426}", "context" -> 
    "StandardAtmosphere`", "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Symbol", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "AtmosphericPlot[property] generates a plot of the specified property \
property as a function of geometric altitude. ", "synonyms" -> {}, "title" -> 
    "AtmosphericPlot", "type" -> "Symbol", "uri" -> 
    "StandardAtmosphere/ref/AtmosphericPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 657, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 53, 1, 70, "ObjectName",
 CellID->23296],
Cell[1336, 46, 530, 15, 70, "Usage",
 CellID->19411]
}, Open  ]],
Cell[CellGroupData[{
Cell[1903, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2381, 83, 246, 9, 70, "Notes",
 CellID->397263883],
Cell[2630, 94, 142, 6, 70, "Notes",
 CellID->27873],
Cell[2775, 102, 3464, 83, 70, "2ColumnTableMod",
 CellID->177078669]
}, Closed]],
Cell[CellGroupData[{
Cell[6276, 190, 314, 9, 70, "TutorialsSection",
 CellID->24716],
Cell[6593, 201, 177, 4, 70, "Tutorials",
 CellID->9562]
}, Open  ]],
Cell[6785, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

