(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6186,        215]
NotebookOptionsPosition[      4430,        160]
NotebookOutlinePosition[      5543,        190]
CellTagsIndexPosition[      5500,        187]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Standard Atmosphere Package" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Standard Atmosphere Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AtmosphericPlot" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/AtmosphericPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"AtmosphericPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KineticTemperature", "ObjectName",
 CellID->26658],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KineticTemperature", "[", 
       StyleBox["altitude", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the kinetic temperature at the specified \
altitude ",
     Cell[BoxData[
      StyleBox["altitude", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The altitude ",
 Cell[BoxData[
  StyleBox["altitude", "TI"]], "InlineFormula"],
 " can be specified using distance units such as ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1695]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13784],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AtmosphericPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->25027]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7487],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "Tutorials",
 CellID->23158]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KineticTemperature - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 3.4272126}", "context" -> 
    "StandardAtmosphere`", "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Symbol", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "KineticTemperature[altitude] gives the kinetic temperature at the \
specified altitude altitude.", "synonyms" -> {}, "title" -> 
    "KineticTemperature", "type" -> "Symbol", "uri" -> 
    "StandardAtmosphere/ref/KineticTemperature"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1268, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1891, 61, 56, 1, 70, "ObjectName",
 CellID->26658],
Cell[1950, 64, 511, 16, 70, "Usage",
 CellID->19587]
}, Open  ]],
Cell[CellGroupData[{
Cell[2498, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2976, 102, 301, 11, 70, "Notes",
 CellID->1695]
}, Closed]],
Cell[CellGroupData[{
Cell[3314, 118, 311, 9, 70, "SeeAlsoSection",
 CellID->13784],
Cell[3628, 129, 229, 6, 70, "SeeAlso",
 CellID->25027]
}, Open  ]],
Cell[CellGroupData[{
Cell[3894, 140, 313, 9, 70, "TutorialsSection",
 CellID->7487],
Cell[4210, 151, 178, 4, 70, "Tutorials",
 CellID->23158]
}, Open  ]],
Cell[4403, 158, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

