(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6139,        214]
NotebookOptionsPosition[      4416,        160]
NotebookOutlinePosition[      5496,        189]
CellTagsIndexPosition[      5453,        186]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Standard Atmosphere Package" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Standard Atmosphere Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AtmosphericPlot" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/AtmosphericPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"AtmosphericPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanDensity", "ObjectName",
 CellID->20994],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MeanDensity", "[", 
       StyleBox["altitude", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the mean density of air at the specified \
altitude ",
     Cell[BoxData[
      StyleBox["altitude", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The altitude ",
 Cell[BoxData[
  StyleBox["altitude", "TI"]], "InlineFormula"],
 " can be specified using distance units such as ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15521]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28189],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AtmosphericPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1589],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "Tutorials",
 CellID->28991]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanDensity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 3.5834666}", "context" -> 
    "StandardAtmosphere`", "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Symbol", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "MeanDensity[altitude] gives the mean density of air at the specified \
altitude altitude.", "synonyms" -> {}, "title" -> "MeanDensity", "type" -> 
    "Symbol", "uri" -> "StandardAtmosphere/ref/MeanDensity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1268, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1891, 61, 49, 1, 70, "ObjectName",
 CellID->20994],
Cell[1943, 64, 504, 16, 70, "Usage",
 CellID->23288]
}, Open  ]],
Cell[CellGroupData[{
Cell[2484, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2962, 102, 302, 11, 70, "Notes",
 CellID->15521]
}, Closed]],
Cell[CellGroupData[{
Cell[3301, 118, 311, 9, 70, "SeeAlsoSection",
 CellID->28189],
Cell[3615, 129, 228, 6, 70, "SeeAlso",
 CellID->8892]
}, Open  ]],
Cell[CellGroupData[{
Cell[3880, 140, 313, 9, 70, "TutorialsSection",
 CellID->1589],
Cell[4196, 151, 178, 4, 70, "Tutorials",
 CellID->28991]
}, Open  ]],
Cell[4389, 158, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

