(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6555,        226]
NotebookOptionsPosition[      4833,        172]
NotebookOutlinePosition[      5905,        201]
CellTagsIndexPosition[      5862,        198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Standard Atmosphere Package" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Standard Atmosphere Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AtmosphericPlot" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/AtmosphericPlot"], "SpeedOfSound" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SpeedOfSound"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AtmosphericPlot\"\>", 
       2->"\<\"SpeedOfSound\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SoundSpeed", "ObjectName",
 CellID->31893],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SoundSpeed", "[", 
       StyleBox["altitude", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the speed of sound at the specified altitude ",
     Cell[BoxData[
      StyleBox["altitude", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The altitude ",
 Cell[BoxData[
  StyleBox["altitude", "TI"]], "InlineFormula"],
 " can be specified using distance units such as ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11550],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtmosphericPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpeedOfSound",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SpeedOfSound"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->663691250]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21020],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "Tutorials",
 CellID->24809]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SoundSpeed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 11.2711634}", "context" -> 
    "StandardAtmosphere`", "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Symbol", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "SoundSpeed[altitude] gives the speed of sound at the specified altitude \
altitude.", "synonyms" -> {}, "title" -> "SoundSpeed", "type" -> "Symbol", 
    "uri" -> "StandardAtmosphere/ref/SoundSpeed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1407, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2030, 63, 48, 1, 70, "ObjectName",
 CellID->31893],
Cell[2081, 66, 496, 15, 70, "Usage",
 CellID->29654]
}, Open  ]],
Cell[CellGroupData[{
Cell[2614, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3092, 103, 302, 11, 70, "Notes",
 CellID->23465]
}, Closed]],
Cell[CellGroupData[{
Cell[3431, 119, 311, 9, 70, "SeeAlsoSection",
 CellID->11550],
Cell[3745, 130, 514, 17, 70, "SeeAlso",
 CellID->663691250]
}, Open  ]],
Cell[CellGroupData[{
Cell[4296, 152, 314, 9, 70, "TutorialsSection",
 CellID->21020],
Cell[4613, 163, 178, 4, 70, "Tutorials",
 CellID->24809]
}, Open  ]],
Cell[4806, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

