(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15730,        495]
NotebookOptionsPosition[     12583,        389]
NotebookOutlinePosition[     13904,        426]
CellTagsIndexPosition[     13819,        421]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxOrientation" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxOrientation"], "BoxLabels" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxLabels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxOrientation\"\>", 
       2->"\<\"BoxLabels\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxExtraSpacing", "ObjectName",
 CellID->6450],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoxExtraSpacing"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BoxWhiskerPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
      "InlineFormula"],
     " which specifies spacing adjustments to be applied when plotting \
multiple boxes."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are nonnegative numbers or a list of nonnegative numbers. \
The default setting is ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "Notes",
 CellID->24961],

Cell[TextData[{
 "A setting of ",
 Cell[BoxData["1"], "InlineFormula"],
 " is equivalent to the space used for a single box."
}], "Notes",
 CellID->14199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"BoxExtraSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that successive spacings ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be used cyclically for successive plots."
}], "Notes",
 CellID->20855]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23224108],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->5789604],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->151061302],

Cell["A default box and whisker plot for 2 data sets:", "ExampleText",
 CellID->53154001],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "100"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "100"}], "]"}]}], ";"}]}], "Input",\

 CellLabel->"In[2]:=",
 CellID->73404589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data1", ",", "data2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->227635225],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81vEkEUH1gKmrYRNTSkUUs48HHSFK29lEMP9WRiBWsaYwhBG0g1mNqT
sXrzysWLpz1Se/Qf4B8w4eKdI4kX/gR8b3bX/QjLzn5UFnmT3bfz9r3fb94u
j50ZZnlcP22+fls/bTXqmUcn9XfNVuN9Zq99AqekCGORJux30wzqY8aUHUsL
dqVqX2uAlABwDscYHA/42VcoJY1nzK2azmy9vlv0ZxO9Lix61YdXF0VM17XI
8KqioF2ox+cCd0KvXVO5DmGP/D1jbLficOVoj+CN4kg0uEN4bysYJIoDW2uZ
67IsM6XkUaCu2n8LRzQmz0v0nJR3YYpvUT3jY+VZuySMSBgszBWSSSoESlRT
DZ4xYaarFgsyLYG67wohfofMz3V39yqqccxBNiy6Jz2lyJNyiDwpM8iTMoM8
xT0T6qcoPja8YrGIj36DG0dPimH6ONp71N6R/kfRBa53Op3PvLACCrSbdLCr
/r8cmEAv7xzBxgoopK0HhyZd9xdg+vjhJ2ysgoKQM0CiIfxREpKQlOmEJCRl
OiEJSd8RQk5BvnzxDTZWQeEOubFRgo1VUAQcLc4BcSZnnSWLM/DVJ9NqjHUe
6ZcL5785Bw6+Ni/hpFEpyqpzr9dT7eUA4z3j9sFgkMlksFqde26vWWDP6DYj
iYmYnJhEesf5u6rZMD3l9tFotLu7t729wwoopFLp4crKKlaLXG80jgx8flqC
mJPJlN7/7T/5sr5+B01F/8xra7d0+5vjH8RMzCFhFnlmhSVWYibmQJljMRy6
syoKaXl51YAPbcz/LbPpSWRaG9vcrNislfmNXZblqet7+lvB3luyrjmeERMx
EZPlm3/ZsQyHw3g8kc9vsQIKKZe7n0rd1vVs9l42m3PH/Inr/X6/xwvLo5C6
3W46ncZqketwDaq/fb9iZT7Xrt5xHkXIMCDx9yl0dHpDxZ7B7dvmwTF95Tqk
qtrzXec9X7vdTiaTWL3JdT2Ly1NbmvQukLWFG5yxVquZdNEWpl3LOACk3W+N
YX2PbNE9J/UeYYqPPGflSZlBnpRD5OnV090/hTWg/T+P/6XV/A9wFvkDPP+n
QA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22390663]
}, Open  ]],

Cell["Add an additional box width between the plots:", "ExampleText",
 CellID->1011512019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data1", ",", "data2", ",", 
   RowBox[{"BoxExtraSpacing", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->194370801],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM9vEkEUHhgqGJJKJRITf+ymB/FmqLYpRpQfWi82JjSatEYJaTRwMJra
kzEhXOTKUU8cSf0XPHBsVBKu3PgP5MgR3xtYYTe7ZYdd28W8SfbNvH3f983s
MuwwO7tsFw9Lr98WD8v7RfXxQfF9qbz/Qd16dwC7uI8xXwm2W5cZlIeMjTZM
ZdhGRetSHiwHwk/IA5A/Ent30HJNZyiims8sUb8M/kNTVNvg5xygfqAJTHyt
ZXhUfvDa43zLxpmYlC6MtXZh8/3dM11vdsaRY9yHJ0owMSDHmL8ud5honltG
E8KvVCpslK6j4ZFIpN/va2yfJTsj/FarlU6nNfRFQp8hGsGL1F5C69HnhqNr
95IUKziFZtJsxsc0SH7NnWIHpNTOG9CotgTuA2mW3FnTjx3y58+v6XiiHxDa
DTRdDQlNfY/Qi4+m3kRo6k2EngcdHH/icr+JQwa03CzA3TmFWVtmzymcHYEz
tjszCkVDV0RiChpeKBRUVcWiMLxWqw0GA4T+nqG0t/cqfiN9P/WGqWj4xvou
5FhUhB8OL/d6PZtK208qnz62WRYNj8WuEvOUmUj0fiuJSUzq6cQkJvV0YhKT
viPEtGLm88/uJgsvX3xlWTR8ZSVmk5nJ5KJRVVFusywaHgqFu92uW63FuSDO
5owzaPsKYoVOt0JlnE861cL58LUZGl9EHOaTbJQUNOiPlRIutvfIgM8uvPa8
vcBaUbZHkhIpzVKyMzou3lGdjdJnET8+Pk4mU5ubKaai4cFgCHIsKsKHIEAQ
qjqsqdFo3Izfm4x/4MAul5TX7zydxMEhZVL2iLKda5ZX2krKpOyecr1e9/vx
RyXLoeHVanWK7802/8/KuiuRbq1sbW3HYq3Mads7nY7N9b35azKuOx6REimR
kuGb/6/b0mw2I5FL8fgGU9HwaPQK5FhUhA9BgMgpfwOzird0ENMSialgVm0r
GN/PsZ4vEdMLTLwPhYFZT6RYK8g+be+e0nfhw8A5HvGWxQgHeJ0/GlgRmjix
JrNngMxrgDF1rhpOOhbc6dYbDFb3FhflGTNCm6PNRhUvt5fQXkZTbyI09T1C
ex0t/1a5RrZ+U/00o/p/DGC+P/xzd/A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->270829367]
}, Open  ]],

Cell["Specify different spacings between plots:", "ExampleText",
 CellID->612239877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"BoxExtraSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->162152457],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXE1MG0cUHu+uIWuS4BBsnLYxDmogbdUEyU6agIAghZ9LVClt1KIKjBW1
YLWRaUKbtqrEkQMHzj35UomjD5x8ypFLJR96QD1x5FIJqReO7pu3s+zueLHX
8a53Fq0lv5k38+a9b2dnxjPzPPO0sLn+7cvCZvFFIbPwqrCxXnzxOjNfegVJ
coSQyDoh5M8UgXgdYvilnyJ8tSgfGwMqg9gchAqEK4z/lebKevk6SaH0HS51
zsQDJQUu/2dHWuY5fpXjNxm2G7alFzh+GYgE7BsO23uOSq/YPIF0buknlCgG
31gDP1nKjzFugYX5prXd/M3ZxYjMHlaPmnRSe1GGckkTsSBXGp5F4TQkWtRd
nuPfcHwSSMSxZZowyGmYRf7w8PAtfoiMBPItPOQz+SVXEZlLxoFEdevVapVG
FSBTKLe9vf0YP0RGAjIWHvI9R9iP/NHRkcmyNDIyEkUG0pncY67cf+9skbYP
aWtra/F8jab22VPX+kC0bS1xz0pob6NcLm/hh8hI8vm8hYfXzOS/R/lKpcKe
ScVnTKVSp6eneisxEFBDTi1LaKlUKsXjcRpVOMs/ojy8Si3J1E6cPuuK3j4y
mQyN/hJqDKRGc6uaRMnj4+PZ2bmHD6dIjBJZURQIaVRFHjJBhIo+6xi7ZhHE
0zc/Wv7mDxKjRP7q+S6ENKoiD5lMo4sWx8Ye/P7bXyRJiQxMACyodTZesF6u
ApFmZmb6sHdDOpP71GME0Azu3X06PfUdUYFIE49WY5SRIRGyqMhd7xFAy6BK
E6gZGE8sU8Pdtejfs4aW3bX8A/K7u7um3kpkyNQmBCSGfK1WM9lvnOeY5+HI
28ycvEEO+qFX672cyA/uL1n44eEsPAEVjdXt53xRDnvXcIOcoQ/AtsDZw+Gi
dU4FLgmCr5fDJwlaj0HB2Xot4iNSB2sc/9B1Z8wMHhIv5glBrYsQSYgkWEjC
3hsiCZF4jWR/f//69ffp0iGJ64dE4ma1Wu1m7wVzYNRAkEymhXsrmlfk4OCA
+SQuoZdgb28vlUrRaAx5Y9WY9w2p5nerVCrxeAJSiUqJPDqaGxi4QaMx5Ht6
etluod9Iy+Xy/dznRn4y+YHmxrgQyBr2DKJnKFmG26sIF7G3XI0HAbfuddTD
TncPvMRp3pWxbxfZ7GfzT17T7fcE7sEDA0l+4qY4z18N37r14dDQ6PBwliQo
kYGBJHHxCtEuTGMGv3cjbq8TdwwWG5kbq5wzRHfGJumwkMSxYWBgSJC62tnZ
uXJlkA4ASRwFentVQZBd/PblCzLmkUhoHol0tlQqCYpsbW1NEGTdHy2C275C
ZCGyEFk4WoTIQmSt91zMvm8i9Mqvy/7w7iIXfvclsHUtB6hV8zgFrmduH0YS
ulWIOx6LjSycI3mJrFar9fVdNfxO/f2DEBp+KcjUnGY+Ir2nI2W+PfWt9fyR
yvn2/EM6yck/C5F4jMTJ6CB6XfC+4Nu3s9eupYw+efnyVc99wTyyL5Bv5U83
zvx1Dxl/Tse7/xyElptYtvyn/ZOP5ycerTb/j/u79lZ7BNbTPI3nA05OTkxP
7E1dtHtGolh8yWarSZy9As/yJ1yzJOJ5uXbX+y5YdOkMrbsW9bPVblo6z1t+
UevQu5bZ7snoi9VHW52U9htbqLH5GXbQyGZqEjdTU5DXJpBUtPMz7JrFjY0N
dseBhHcbTE9Pp9NpGlW42xaaW2zW6v7pGGuooTsaRH+LfyPv9M4IJxrNN3ZQ
Xv/wp/fsflP0e0wkmLNq95loMGieNhc0+rP9bSvGTSL/nuHgLeOPm4PbSmBs
WFxcNO5JyeVy4+PjRk82VnkaNqgMy70qMJRZeG3q3yk2Sp63WV5P+LLNcjT8
Gr4RjLYuQ4NlLWozg6C5OM5jrMm9QZH/AZi+Pe0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->540907336]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6473],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxOrientation",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxOrientation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxLabels"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5716],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->10573]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxExtraSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 18.5525998}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxExtraSpacing is an option for BoxWhiskerPlot which specifies spacing \
adjustments to be applied when plotting multiple boxes.", "synonyms" -> {}, 
    "title" -> "BoxExtraSpacing", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/BoxExtraSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4091, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23224108]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13677, 414}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1382, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2005, 63, 52, 1, 70, "ObjectName",
 CellID->6450],
Cell[2060, 66, 583, 17, 70, "Usage",
 CellID->14801]
}, Open  ]],
Cell[CellGroupData[{
Cell[2680, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3158, 105, 190, 6, 70, "Notes",
 CellID->24961],
Cell[3351, 113, 154, 5, 70, "Notes",
 CellID->14199],
Cell[3508, 120, 546, 19, 70, "Notes",
 CellID->20855]
}, Closed]],
Cell[CellGroupData[{
Cell[4091, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23224108],
Cell[CellGroupData[{
Cell[4475, 158, 146, 5, 70, "ExampleSection",
 CellID->5789604],
Cell[4624, 165, 141, 4, 70, "Input",
 CellID->151061302],
Cell[4768, 171, 89, 1, 70, "ExampleText",
 CellID->53154001],
Cell[4860, 174, 450, 16, 70, "Input",
 CellID->73404589],
Cell[CellGroupData[{
Cell[5335, 194, 141, 4, 28, "Input",
 CellID->227635225],
Cell[5479, 200, 1314, 26, 324, "Output",
 Evaluatable->False,
 CellID->22390663]
}, Open  ]],
Cell[6808, 229, 90, 1, 70, "ExampleText",
 CellID->1011512019],
Cell[CellGroupData[{
Cell[6923, 234, 195, 5, 28, "Input",
 CellID->194370801],
Cell[7121, 241, 1343, 26, 324, "Output",
 Evaluatable->False,
 CellID->270829367]
}, Open  ]],
Cell[8479, 270, 84, 1, 70, "ExampleText",
 CellID->612239877],
Cell[CellGroupData[{
Cell[8588, 275, 408, 13, 28, "Input",
 CellID->162152457],
Cell[8999, 290, 2144, 39, 185, "Output",
 Evaluatable->False,
 CellID->540907336]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11204, 336, 310, 9, 70, "SeeAlsoSection",
 CellID->6473],
Cell[11517, 347, 499, 17, 70, "SeeAlso",
 CellID->28274]
}, Open  ]],
Cell[CellGroupData[{
Cell[12053, 369, 313, 9, 70, "TutorialsSection",
 CellID->5716],
Cell[12369, 380, 172, 4, 70, "Tutorials",
 CellID->10573]
}, Open  ]],
Cell[12556, 387, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

